/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.wthit;

import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mekanism.common.integration.lookingat.LookingAtElement;
import mekanism.common.integration.lookingat.LookingAtUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class WTHITTooltipRenderer
implements IBlockComponentProvider,
IEntityComponentProvider {
    static final WTHITTooltipRenderer INSTANCE = new WTHITTooltipRenderer();

    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        this.append(tooltip, accessor.getServerData(), config);
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.append(tooltip, accessor.getServerData(), config);
    }

    private void append(ITooltip tooltip, CompoundTag data, IPluginConfig config) {
        LookingAtUtils.appendHwylaTooltip(data, arg_0 -> ((ITooltip)tooltip).addLine(arg_0), (lastText, element, name) -> {
            if (config.getBoolean(name)) {
                tooltip.addLine((ITooltipComponent)new MekElement((Component)lastText, (LookingAtElement)element));
            }
        });
    }

    private record MekElement(@Nullable Component text, LookingAtElement element) implements ITooltipComponent
    {
        public int getWidth() {
            if (this.text == null) {
                return this.element.getWidth();
            }
            return Math.max(this.element.getWidth(), 96);
        }

        public int getHeight() {
            if (this.text == null) {
                return this.element.getHeight() + 2;
            }
            return this.element.getHeight() + 16;
        }

        public void render(PoseStack poseStack, int x, int y, float delta) {
            if (this.text != null) {
                LookingAtElement.renderScaledText(Minecraft.m_91087_(), poseStack, x + 4, y + 3, 0xFFFFFF, 92.0f, this.text);
                y += 13;
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)x, (double)y, 0.0);
            this.element.render(poseStack, 0, 1);
            poseStack.m_85849_();
        }
    }
}

