/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSInfuseType;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.INSSFakeGroupManager;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

@RecipeTypeMapper
public class MetallurgicInfuserRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekMetallurgicInfuser";
    }

    public String getDescription() {
        return "Maps Mekanism metallurgic infuser recipes.";
    }

    public boolean canHandle(RecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.METALLURGIC_INFUSING.get();
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, Recipe<?> iRecipe, INSSFakeGroupManager groupManager) {
        if (!(iRecipe instanceof MetallurgicInfuserRecipe)) {
            return false;
        }
        MetallurgicInfuserRecipe recipe = (MetallurgicInfuserRecipe)iRecipe;
        boolean handled = false;
        List<@NotNull TYPE> infuseTypeRepresentations = ((ChemicalStackIngredient.InfusionStackIngredient)recipe.getChemicalInput()).getRepresentations();
        List<@NotNull TYPE> itemRepresentations = recipe.getItemInput().getRepresentations();
        for (InfusionStack infuseTypeRepresentation : infuseTypeRepresentations) {
            NSSInfuseType nssInfuseType = NSSInfuseType.createInfuseType(infuseTypeRepresentation);
            for (ItemStack itemRepresentation : itemRepresentations) {
                ItemStack output = recipe.getOutput(itemRepresentation, infuseTypeRepresentation);
                if (output.m_41619_()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssInfuseType, infuseTypeRepresentation.getAmount());
                ingredientHelper.put(itemRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

