/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IConfigurable;
import mekanism.api.IIncrementalEnum;
import mekanism.api.MekanismAPI;
import mekanism.api.RelativeSide;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeStateFacing;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemEnergized;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.lib.radial.IRadialEnumModeItem;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tier.BinTier;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemConfigurator
extends ItemEnergized
implements IRadialEnumModeItem<ConfiguratorMode>,
IItemHUDProvider {
    public static final Lazy<RadialData<ConfiguratorMode>> LAZY_RADIAL_DATA = Lazy.of(() -> MekanismAPI.getRadialDataHelper().dataForEnum(Mekanism.rl("configurator_mode"), ConfiguratorMode.class));

    public ItemConfigurator(Item.Properties properties) {
        super(MekanismConfig.gear.configuratorChargeRate, MekanismConfig.gear.configuratorMaxEnergy, properties.m_41497_(Rarity.UNCOMMON));
    }

    @Override
    public void m_7373_(@NotNull ItemStack stack, Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add((Component)MekanismLang.STATE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return TextComponentUtil.build(EnumColor.AQUA, super.m_7626_(stack));
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        Level world = context.m_43725_();
        if (!world.f_46443_ && player != null) {
            BlockPos pos = context.m_8083_();
            Direction side = context.m_43719_();
            ItemStack stack = context.m_43722_();
            BlockEntity tile = WorldUtils.getTileEntity((BlockGetter)world, pos);
            ConfiguratorMode mode = (ConfiguratorMode)this.getMode(stack);
            if (mode.isConfigurating()) {
                ISideConfiguration config;
                TransmissionType transmissionType = Objects.requireNonNull(mode.getTransmission(), "Configurating state requires transmission type");
                if (tile instanceof ISideConfiguration && (config = (ISideConfiguration)tile).getConfig().supports(transmissionType)) {
                    ConfigInfo info = config.getConfig().getConfig(transmissionType);
                    if (info != null) {
                        RelativeSide relativeSide = RelativeSide.fromDirections(config.getDirection(), side);
                        DataType dataType = info.getDataType(relativeSide);
                        if (!player.m_6144_()) {
                            player.m_213846_(MekanismUtils.logFormat(MekanismLang.CONFIGURATOR_VIEW_MODE.translate(transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName())));
                        } else {
                            if (!MekanismAPI.getSecurityUtils().canAccessOrDisplayError(player, (ICapabilityProvider)tile)) {
                                return InteractionResult.FAIL;
                            }
                            if (!player.m_7500_()) {
                                IEnergyContainer energyContainer = StorageUtils.getEnergyContainer(stack, 0);
                                FloatingLong energyPerConfigure = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerConfigure.get();
                                if (energyContainer == null || energyContainer.extract(energyPerConfigure, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerConfigure)) {
                                    return InteractionResult.FAIL;
                                }
                                energyContainer.extract(energyPerConfigure, Action.EXECUTE, AutomationType.MANUAL);
                            }
                            DataType old = dataType;
                            dataType = info.incrementDataType(relativeSide);
                            if (dataType != old) {
                                player.m_213846_(MekanismUtils.logFormat(MekanismLang.CONFIGURATOR_TOGGLE_MODE.translate(transmissionType, dataType.getColor(), dataType, dataType.getColor().getColoredName())));
                                config.getConfig().sideChanged(transmissionType, relativeSide);
                            }
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!MekanismAPI.getSecurityUtils().canAccessOrDisplayError(player, (ICapabilityProvider)tile)) {
                    return InteractionResult.FAIL;
                }
                Optional capability = CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.CONFIGURABLE, side).resolve();
                if (capability.isPresent()) {
                    IConfigurable config2 = (IConfigurable)capability.get();
                    if (player.m_6144_()) {
                        return config2.onSneakRightClick(player);
                    }
                    return config2.onRightClick(player);
                }
            } else if (mode == ConfiguratorMode.EMPTY) {
                IMekanismInventory inv;
                if (tile instanceof IMekanismInventory && (inv = (IMekanismInventory)tile).hasInventory()) {
                    IEnergyContainer energyContainer;
                    TileEntityBin bin;
                    if (!MekanismAPI.getSecurityUtils().canAccessOrDisplayError(player, (ICapabilityProvider)tile)) {
                        return InteractionResult.FAIL;
                    }
                    boolean creative = player.m_7500_();
                    if (tile instanceof TileEntityBin && (bin = (TileEntityBin)tile).getTier() == BinTier.CREATIVE) {
                        if (creative) {
                            bin.getBinSlot().setEmpty();
                            return InteractionResult.SUCCESS;
                        }
                        return InteractionResult.FAIL;
                    }
                    IEnergyContainer iEnergyContainer = energyContainer = creative ? null : StorageUtils.getEnergyContainer(stack, 0);
                    if (!creative && energyContainer == null) {
                        return InteractionResult.FAIL;
                    }
                    FloatingLong energyPerItemDump = (FloatingLong)MekanismConfig.gear.configuratorEnergyPerItem.get();
                    for (IInventorySlot inventorySlot : inv.getInventorySlots(null)) {
                        if (inventorySlot.isEmpty()) continue;
                        if (!creative) {
                            if (energyContainer.extract(energyPerItemDump, Action.SIMULATE, AutomationType.MANUAL).smallerThan(energyPerItemDump)) break;
                            energyContainer.extract(energyPerItemDump, Action.EXECUTE, AutomationType.MANUAL);
                        }
                        InventoryUtils.dropStack(inventorySlot.getStack().m_41777_(), slotStack -> Block.m_152435_((Level)world, (BlockPos)pos, (Direction)side, (ItemStack)slotStack));
                        inventorySlot.setEmpty();
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (mode == ConfiguratorMode.ROTATE) {
                    if (tile instanceof TileEntityMekanism) {
                        TileEntityMekanism tileMekanism = (TileEntityMekanism)tile;
                        if (!tileMekanism.isDirectional()) {
                            return InteractionResult.PASS;
                        }
                        if (!MekanismAPI.getSecurityUtils().canAccessOrDisplayError(player, (ICapabilityProvider)tile)) {
                            return InteractionResult.FAIL;
                        }
                        if (Attribute.matches(tileMekanism.getBlockType(), AttributeStateFacing.class, AttributeStateFacing::canRotate)) {
                            if (!player.m_6144_()) {
                                tileMekanism.setFacing(side);
                            } else if (player.m_6144_()) {
                                tileMekanism.setFacing(side.m_122424_());
                            }
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (mode == ConfiguratorMode.WRENCH) {
                    return InteractionResult.PASS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return this.getMode(stack) == ConfiguratorMode.WRENCH;
    }

    @Override
    public void addHUDStrings(List<Component> list, Player player, ItemStack stack, EquipmentSlot slotType) {
        list.add((Component)MekanismLang.MODE.translateColored(EnumColor.PINK, this.getMode(stack)));
    }

    @Override
    public void changeMode(@NotNull Player player, @NotNull ItemStack stack, int shift, boolean displayChangeMessage) {
        ConfiguratorMode newMode;
        ConfiguratorMode mode = (ConfiguratorMode)this.getMode(stack);
        if (mode != (newMode = (ConfiguratorMode)mode.adjust(shift))) {
            this.setMode(stack, player, newMode);
            if (displayChangeMessage) {
                player.m_213846_(MekanismUtils.logFormat(MekanismLang.CONFIGURE_STATE.translate(newMode)));
            }
        }
    }

    @Override
    @NotNull
    public Component getScrollTextComponent(@NotNull ItemStack stack) {
        return ((ConfiguratorMode)this.getMode(stack)).getTextComponent();
    }

    @Override
    public String getModeSaveKey() {
        return "state";
    }

    @Override
    @NotNull
    public RadialData<ConfiguratorMode> getRadialData(ItemStack stack) {
        return (RadialData)LAZY_RADIAL_DATA.get();
    }

    @Override
    public ConfiguratorMode getModeByIndex(int ordinal) {
        return ConfiguratorMode.byIndexStatic(ordinal);
    }

    @NothingNullByDefault
    public static enum ConfiguratorMode implements IIncrementalEnum<ConfiguratorMode>,
    IHasTextComponent,
    IRadialMode
    {
        CONFIGURATE_ITEMS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ITEM, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_FLUIDS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.FLUID, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_GASES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.GAS, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_INFUSE_TYPES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.INFUSION, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_PIGMENTS(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.PIGMENT, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_SLURRIES(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.SLURRY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_ENERGY(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.ENERGY, EnumColor.BRIGHT_GREEN, true, null),
        CONFIGURATE_HEAT(MekanismLang.CONFIGURATOR_CONFIGURATE, TransmissionType.HEAT, EnumColor.BRIGHT_GREEN, true, null),
        EMPTY(MekanismLang.CONFIGURATOR_EMPTY, null, EnumColor.DARK_RED, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "empty.png")),
        ROTATE(MekanismLang.CONFIGURATOR_ROTATE, null, EnumColor.YELLOW, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "rotate.png")),
        WRENCH(MekanismLang.CONFIGURATOR_WRENCH, null, EnumColor.PINK, false, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "wrench.png"));

        private static final ConfiguratorMode[] MODES;
        private final ILangEntry langEntry;
        @Nullable
        private final TransmissionType transmissionType;
        private final EnumColor color;
        private final boolean configurating;
        private final ResourceLocation icon;

        private ConfiguratorMode(ILangEntry langEntry, TransmissionType transmissionType, @Nullable EnumColor color, boolean configurating, ResourceLocation icon) {
            this.langEntry = langEntry;
            this.transmissionType = transmissionType;
            this.color = color;
            this.configurating = configurating;
            this.icon = transmissionType == null ? Objects.requireNonNull(icon, "Icon should only be null if there is a transmission type present.") : MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, transmissionType.getTransmission() + ".png");
        }

        @Override
        public Component getTextComponent() {
            if (this.transmissionType == null) {
                return this.langEntry.translateColored(this.color, new Object[0]);
            }
            return this.langEntry.translateColored(this.color, this.transmissionType);
        }

        @Override
        public EnumColor color() {
            return this.color;
        }

        public boolean isConfigurating() {
            return this.configurating;
        }

        @Nullable
        public TransmissionType getTransmission() {
            return this.transmissionType;
        }

        @Override
        @NotNull
        public ConfiguratorMode byIndex(int index) {
            return ConfiguratorMode.byIndexStatic(index);
        }

        public static ConfiguratorMode byIndexStatic(int index) {
            return MathUtils.getByIndexMod(MODES, index);
        }

        @Override
        @NotNull
        public Component sliceName() {
            return this.configurating && this.transmissionType != null ? this.transmissionType.getLangEntry().translateColored(this.color, new Object[0]) : this.getTextComponent();
        }

        @Override
        @NotNull
        public ResourceLocation icon() {
            return this.icon;
        }

        static {
            MODES = ConfiguratorMode.values();
        }
    }
}

