/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.resource;

import mekanism.common.resource.IResource;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;

public enum BlockResourceInfo implements IResource
{
    OSMIUM("osmium", 7.5f, 12.0f, MaterialColor.f_76421_),
    RAW_OSMIUM("raw_osmium", 7.5f, 12.0f, MaterialColor.f_76421_, Material.f_76278_),
    TIN("tin", 5.0f, 6.0f, MaterialColor.f_76372_),
    RAW_TIN("raw_tin", 5.0f, 6.0f, MaterialColor.f_76372_, Material.f_76278_),
    LEAD("lead", 5.0f, 9.0f, MaterialColor.f_76420_),
    RAW_LEAD("raw_lead", 5.0f, 9.0f, MaterialColor.f_76420_, Material.f_76278_),
    URANIUM("uranium", 5.0f, 9.0f, MaterialColor.f_76399_),
    RAW_URANIUM("raw_uranium", 5.0f, 9.0f, MaterialColor.f_76399_, Material.f_76278_),
    CHARCOAL("charcoal", 5.0f, 6.0f, MaterialColor.f_76365_, Material.f_76278_, 16000),
    FLUORITE("fluorite", 5.0f, 9.0f, MaterialColor.f_76406_),
    BRONZE("bronze", 5.0f, 9.0f, MaterialColor.f_76413_),
    STEEL("steel", 5.0f, 9.0f, MaterialColor.f_76409_),
    REFINED_OBSIDIAN("refined_obsidian", 50.0f, 2400.0f, MaterialColor.f_76422_, Material.f_76278_, -1, 8, false, true, PushReaction.BLOCK),
    REFINED_GLOWSTONE("refined_glowstone", 5.0f, 6.0f, MaterialColor.f_76416_, Material.f_76278_, -1, 15);

    private final String registrySuffix;
    private final MaterialColor materialColor;
    private final PushReaction pushReaction;
    private final boolean portalFrame;
    private final boolean burnsInFire;
    private final Material material;
    private final float resistance;
    private final float hardness;
    private final int burnTime;
    private final int lightValue;

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, MaterialColor materialColor) {
        this(registrySuffix, hardness, resistance, materialColor, Material.f_76279_);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, MaterialColor materialColor, Material material) {
        this(registrySuffix, hardness, resistance, materialColor, material, -1);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, MaterialColor materialColor, Material material, int burnTime) {
        this(registrySuffix, hardness, resistance, materialColor, material, burnTime, 0);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, MaterialColor materialColor, Material material, int burnTime, int lightValue) {
        this(registrySuffix, hardness, resistance, materialColor, material, burnTime, lightValue, true, false, PushReaction.NORMAL);
    }

    private BlockResourceInfo(String registrySuffix, float hardness, float resistance, MaterialColor materialColor, Material material, int burnTime, int lightValue, boolean burnsInFire, boolean portalFrame, PushReaction pushReaction) {
        this.registrySuffix = registrySuffix;
        this.pushReaction = pushReaction;
        this.portalFrame = portalFrame;
        this.burnsInFire = burnsInFire;
        this.burnTime = burnTime;
        this.lightValue = lightValue;
        this.resistance = resistance;
        this.hardness = hardness;
        this.material = material;
        this.materialColor = materialColor;
    }

    @Override
    public String getRegistrySuffix() {
        return this.registrySuffix;
    }

    public float getHardness() {
        return this.hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    public boolean isPortalFrame() {
        return this.portalFrame;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public boolean burnsInFire() {
        return this.burnsInFire;
    }

    public PushReaction getPushReaction() {
        return this.pushReaction;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MaterialColor getMaterialColor() {
        return this.materialColor;
    }
}

