/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.BedFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.BedFrameTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class BedBakedModel
implements IDynamicBakedModel {
    public static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "block/oak_planks");

    private TextureAtlasSprite getTexture() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(TEXTURE);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(BedFrameTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.get(BedFrameTile.MIMIC);
        if (mimic != null && state != null) {
            TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, BedFrameTile.TEXTURE);
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.3125f, 0.0f, 1.0f, texture, tintIndex));
            TextureAtlasSprite pillow = TextureHelper.getWoolTextures().get((Integer)extraData.get(BedFrameTile.PILLOW));
            TextureAtlasSprite blanket = TextureHelper.getWoolTextures().get((Integer)extraData.get(BedFrameTile.BLANKET));
            Integer design = (Integer)extraData.get(BedFrameTile.DESIGN);
            if (design == null) {
                return quads;
            }
            List<TextureAtlasSprite> planksList = TextureHelper.getPlanksTextures();
            Integer desTex = (Integer)extraData.get(BedFrameTile.DESIGN_TEXTURE);
            if (desTex == null || desTex < 0 || desTex > 7) {
                return quads;
            }
            TextureAtlasSprite planks = planksList.get(desTex);
            if (state.m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                    }
                }
            }
            if (state.m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                    case SOUTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case WEST: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                        break;
                    }
                    case NORTH: {
                        quads.addAll(ModelHelper.createCuboid(0.0f, 0.1875f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        break;
                    }
                    case EAST: {
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.0f, 0.1875f, texture, tintIndex));
                        quads.addAll(ModelHelper.createCuboid(0.8125f, 1.0f, 0.0f, 0.1875f, 0.8125f, 1.0f, texture, tintIndex));
                    }
                }
            }
            if (design == 0 || design == 1) {
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, -0.5f, 0.0f, blanket, -1));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 1.0f, 1.5f, blanket, -1));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                        }
                    }
                }
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.5f, 1.0f, pillow, -1));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.5f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, -1));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.5f, pillow, -1));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, -1));
                        }
                    }
                }
            }
            if (design == 1) {
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, texture, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, texture, tintIndex));
                        }
                    }
                }
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, texture, tintIndex));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, texture, tintIndex));
                        }
                    }
                }
            }
            if (design == 2) {
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.0f, 0.875f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, -0.5f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.125f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 1.0f, 1.5f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, texture, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, texture, tintIndex));
                        }
                    }
                }
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.5f, 0.875f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 0.5f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, texture, tintIndex));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.125f, 0.5f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, texture, tintIndex));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5f, 0.875f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, texture, tintIndex));
                            quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, texture, tintIndex));
                        }
                    }
                }
            }
            if (design == 3) {
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.0f, 0.875f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, -0.5f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, planks, -1));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, -1));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 0.125f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.5625f, 1.0f, 1.5f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, planks, -1));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.5625f, 0.0625f, 0.9375f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, -1));
                        }
                    }
                }
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.5f, 0.875f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.875f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.875f, 1.0f, planks, -1));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.125f, 0.5f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.125f, 1.0f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.125f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, -1));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0625f, 0.9375f, 0.3125f, 0.625f, 0.125f, 0.5f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.0625f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.9375f, 1.0f, 0.3125f, 0.625f, 0.125f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.75f, 0.0f, 0.125f, planks, -1));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5f, 0.875f, 0.3125f, 0.625f, 0.0625f, 0.9375f, pillow, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.0f, 0.0625f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.875f, 0.3125f, 0.625f, 0.9375f, 1.0f, planks, -1));
                            quads.addAll(ModelHelper.createCuboid(0.875f, 1.0f, 0.3125f, 0.75f, 0.0f, 1.0f, planks, -1));
                        }
                    }
                }
            }
            if (design == 4) {
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, -0.5f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, -0.5f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, -0.5f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, -0.5625f, -0.5f, blanket, -1));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.5f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.5f, 1.5625f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 1.0f, 1.5f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.0625f, 0.0f, 0.1875f, 0.5625f, 1.0f, 1.5f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 1.0f, 1.5f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.5625f, 1.5f, 1.5625f, blanket, -1));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.3125f, 0.625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(1.0f, 1.0625f, 0.1875f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.1875f, 0.5625f, -0.0625f, 0.0f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.5f, 0.0f, 0.1875f, 0.5625f, 1.0f, 1.0625f, blanket, -1));
                            quads.addAll(ModelHelper.createCuboid(-0.5625f, -0.5f, 0.3125f, 0.5625f, 0.0f, 1.0f, blanket, -1));
                        }
                    }
                }
                if (state.m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                    switch ((Direction)state.m_61143_((Property)BedBlock.f_54117_)) {
                        case SOUTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.5625f, 1.0f, pillow, -1));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 0.4375f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, -1));
                            break;
                        }
                        case NORTH: {
                            quads.addAll(ModelHelper.createCuboid(0.0f, 1.0f, 0.3125f, 0.625f, 0.0f, 0.4375f, pillow, -1));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createCuboid(0.5625f, 1.0f, 0.3125f, 0.625f, 0.0f, 1.0f, pillow, -1));
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return this.getTexture();
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

