/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.bakedmodels.ModelInformation;
import mod.pianomanu.blockcarpentry.bakedmodels.QuadUtils;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.TextureHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class SlopeBakedModel
implements IDynamicBakedModel {
    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getMimicQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    private static void o(List<BakedQuad> quads, Vec3 v1, Vec3 v2, Vec3 v3, Vec3 v4, float ulow, float uhigh, float vlow, float vhigh, boolean invert, int overlayIndex, int overlaySideIndex) {
        TextureAtlasSprite texture = null;
        ModelInformation m = TextureHelper.getOverlayModelInformation(overlayIndex);
        if (overlaySideIndex == 0) {
            texture = m.northTexture;
        }
        if (overlaySideIndex == 1) {
            texture = m.eastTexture;
        }
        if (overlaySideIndex == 2) {
            texture = m.southTexture;
        }
        if (overlaySideIndex == 3) {
            texture = m.westTexture;
        }
        if (overlaySideIndex == 4) {
            texture = m.upTexture;
        }
        if (overlaySideIndex == 5) {
            texture = m.downTexture;
        }
        if (overlayIndex > 0 && texture != null) {
            quads.add(QuadUtils.createQuad(v1, v2, v3, v4, texture, ulow, uhigh, vlow, vhigh, m.tintIndex));
        }
    }

    public List<BakedQuad> getMimicQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, BakedModel model) {
        if (side != null) {
            return new ArrayList<BakedQuad>();
        }
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        TextureAtlasSprite texture = TextureHelper.getTexture(model, rand, extraData, FrameBlockTile.TEXTURE);
        int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
        int overlayIndex = (Integer)extraData.get(FrameBlockTile.OVERLAY);
        quads.addAll(this.createSlope(0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, texture, tintIndex, (Direction)state.m_61143_((Property)StairBlock.f_56841_), (StairsShape)state.m_61143_((Property)StairBlock.f_56843_), (Half)state.m_61143_((Property)StairBlock.f_56842_), overlayIndex));
        return quads;
    }

    private List<BakedQuad> createSlope(float xl, float xh, float yl, float yh, float zl, float zh, TextureAtlasSprite texture, int tintIndex, Direction direction, StairsShape shape, Half half, int overlayIndex) {
        boolean isBottom;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vec3 NWU = SlopeBakedModel.v(xl, yh, zl);
        Vec3 SWU = SlopeBakedModel.v(xl, yh, zh);
        Vec3 NWD = SlopeBakedModel.v(xl, yl, zl);
        Vec3 SWD = SlopeBakedModel.v(xl, yl, zh);
        Vec3 NEU = SlopeBakedModel.v(xh, yh, zl);
        Vec3 SEU = SlopeBakedModel.v(xh, yh, zh);
        Vec3 NED = SlopeBakedModel.v(xh, yl, zl);
        Vec3 SED = SlopeBakedModel.v(xh, yl, zh);
        if (xh - xl > 1.0f || yh - yl > 1.0f || zh - zl > 1.0f) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237115_((String)"An error occured with this block, please report to the mod author (PianoManu)"), true);
            }
            return quads;
        }
        boolean bl = isBottom = half == Half.BOTTOM;
        if (isBottom) {
            quads.add(QuadUtils.createQuad(SWD, NWD, NED, SED, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
            block0 : switch (shape) {
                case STRAIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NED, NEU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWU, SWD, SED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, SWD, SED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            break block0;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWD, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWD, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SED, SEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWD, SEU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SEU, NEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWD, SWU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWD, SWU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWU, SEU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            break block0;
                        }
                        case WEST: {
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWD, NWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWU, SED, NED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SED, NED, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                        }
                    }
                    break;
                }
                case OUTER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(QuadUtils.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWD, NWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWU, SWD, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, SWD, SED, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(SED, NED, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NED, NWU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NED, NEU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NEU, NWD, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NWD, SWD, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(SWD, SED, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SED, NEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SED, SEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SEU, NED, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, NED, NWD, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(NWD, SWD, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWD, SEU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case WEST: {
                            quads.add(QuadUtils.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWD, SWU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWU, SED, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SED, NED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(NED, NWD, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWD, SWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                        }
                    }
                    break;
                }
                case OUTER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(QuadUtils.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWD, NWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWU, SWD, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, SWD, SED, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(SED, NED, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NED, NWU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case NORTH: {
                            quads.add(QuadUtils.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NED, NEU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NEU, NWD, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NWD, SWD, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(SWD, SED, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SED, NEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SED, SEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SEU, NED, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, NED, NWD, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(NWD, SWD, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWD, SEU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWD, SWU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWU, SED, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SED, NED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuadInverted(NED, NWD, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWD, SWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 4);
                        }
                    }
                    break;
                }
                case INNER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NED, NEU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SED, NEU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NEU, NWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NWU, SWU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, SWU, SED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SED, SEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWD, SEU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SEU, NEU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(NEU, NWU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NWU, SWD, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWD, SWU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWD, SWU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWU, SEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWD, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWD, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SEU, NEU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, NEU, NWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case WEST: {
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWD, NWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NED, NWU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWU, SWU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(SWU, SEU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SEU, NED, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                        }
                    }
                    break;
                }
                case INNER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SED, NED, NEU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NED, NEU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SED, NEU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, NEU, NWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NWU, SWU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, SWU, SED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(SWD, SED, SEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SED, SEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWD, SEU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SEU, NEU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(NEU, NWU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NWU, SWD, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NWD, SWD, SWU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWD, SWU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWD, SWU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, SWU, SEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWD, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWD, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SEU, NEU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, NEU, NWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                            break block0;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(NED, NWD, NWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWD, NWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NED, NWU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NWU, SWU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(SWU, SEU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SEU, NED, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                        }
                    }
                }
            }
        } else {
            quads.add(QuadUtils.createQuad(NWU, SWU, SEU, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
            SlopeBakedModel.o(quads, NWU, SWU, SEU, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 4);
            block37 : switch (shape) {
                case STRAIGHT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NEU, SEU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWU, NWD, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NED, SEU, SWU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, SEU, SWU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            break;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SEU, SWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NEU, NED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 4);
                            quads.add(QuadUtils.createQuad(NWU, NED, SED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NED, SED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            break;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SWU, NWU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SEU, SED, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, SED, SWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SED, SWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            break;
                        }
                        case WEST: {
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NWU, NEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWU, SWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(NWD, NEU, SEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NEU, SEU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                        }
                    }
                    break;
                }
                case OUTER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NWU, NEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWU, NWD, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SEU, SWU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWU, NWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(NWD, NEU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NEU, SEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            break;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NEU, SEU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NEU, NED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWU, NWU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWU, NED, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NED, SEU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, SEU, SWU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 1);
                            break;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SEU, SWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SEU, SED, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWU, NEU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NEU, SED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(SED, SWU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SWU, NWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 2);
                            break;
                        }
                        case WEST: {
                            quads.add(QuadUtils.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SWU, NWU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWU, SWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NEU, SEU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SEU, SWD, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SWD, NWU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, NWU, NEU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 3);
                        }
                    }
                    break;
                }
                case OUTER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(QuadUtils.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NWU, NEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWU, NWD, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SEU, SWU, NWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWU, NWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(NWD, NEU, SEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NEU, SEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            break;
                        }
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NEU, SEU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NEU, NED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWU, NWU, NED, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWU, NED, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NED, SEU, SWU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, SEU, SWU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 1);
                            break;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SEU, SWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SEU, SED, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWU, NEU, SED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NEU, SED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(SED, SWU, NWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SWU, NWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 2);
                            break;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SWU, NWU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWU, SWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NEU, SEU, SWD, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SEU, SWD, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SWD, NWU, NEU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, NWU, NEU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 3);
                        }
                    }
                    break;
                }
                case INNER_LEFT: {
                    switch (direction) {
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NEU, SEU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWD, NED, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NED, SEU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWU, SWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SWD, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWD, NWD, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            break;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SEU, SWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NED, SED, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, SED, SWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWU, NWD, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(SWU, NWD, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWD, NED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            break;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SWU, NWU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SED, SWD, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SWD, NWU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NEU, NED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NED, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NED, SED, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            break;
                        }
                        case WEST: {
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NWU, NEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWD, NWD, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, NWD, NEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SEU, SED, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, SED, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SED, SWD, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                        }
                    }
                    break;
                }
                case INNER_RIGHT: {
                    switch (direction) {
                        case WEST: {
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NED, NEU, SEU, NED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, NEU, SEU, NED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWD, NED, SEU, NWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NED, SEU, NWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SEU, SWU, SWD, SEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWU, SWD, SEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SWD, NWD, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SWD, NWD, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            break block37;
                        }
                        case NORTH: {
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(SED, SEU, SWU, SED, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SEU, SWU, SED, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NED, SED, SWU, NED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NED, SED, SWU, NED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, NED, NWD, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, NED, NWD, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWU, NWU, NWD, SWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWU, NWD, SWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(SWU, NWD, NED, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, NWD, NED, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            break block37;
                        }
                        case EAST: {
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SWD, SWU, NWU, SWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, SWU, NWU, SWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuadInverted(SED, SWD, NWU, SED, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SED, SWD, NWU, SED, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 2);
                            quads.add(QuadUtils.createQuad(SEU, SED, NED, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SEU, SED, NED, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                            quads.add(QuadUtils.createQuadInverted(NWU, NEU, NED, NWU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NEU, NED, NWU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 0);
                            quads.add(QuadUtils.createQuad(NWU, NED, SED, NWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NED, SED, NWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 0);
                            break block37;
                        }
                        case SOUTH: {
                            quads.add(QuadUtils.createQuad(NWU, NWD, SWD, SWU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWU, NWD, SWD, SWU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(NWD, NWU, NEU, NWD, texture, 16.0f, 0.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, NWD, NWU, NEU, NWD, 16.0f, 0.0f, 16.0f, 0.0f, false, overlayIndex, 0);
                            quads.add(QuadUtils.createQuadInverted(SWD, NWD, NEU, SWD, texture, 0.0f, 16.0f, 16.0f, 0.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWD, NWD, NEU, SWD, 0.0f, 16.0f, 16.0f, 0.0f, true, overlayIndex, 3);
                            quads.add(QuadUtils.createQuad(SWU, SWD, SED, SEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, SWU, SWD, SED, SEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 2);
                            quads.add(QuadUtils.createQuadInverted(NEU, SEU, SED, NEU, texture, 16.0f, 0.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SEU, SED, NEU, 16.0f, 0.0f, 0.0f, 16.0f, true, overlayIndex, 1);
                            quads.add(QuadUtils.createQuad(NEU, SED, SWD, NEU, texture, 0.0f, 16.0f, 0.0f, 16.0f, tintIndex));
                            SlopeBakedModel.o(quads, NEU, SED, SWD, NEU, 0.0f, 16.0f, 0.0f, 16.0f, false, overlayIndex, 1);
                        }
                    }
                }
            }
        }
        return quads;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

