/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.IFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.LockableFrameTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockModificationHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;

public class FenceGateFrameBlock
extends FenceGateBlock
implements SimpleWaterloggedBlock,
EntityBlock,
IFrameBlock {
    public FenceGateFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53341_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_53342_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_53343_, (Comparable)Boolean.FALSE)).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WATERLOGGED, CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableFrameTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        return this.frameUse(state, level, pos, player, hand, hitresult);
    }

    @Override
    public InteractionResult frameUseServer(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack, BlockHitResult hitresult) {
        this.convertOutdatedTile(state, level, pos, player);
        if (this.shouldCallFrameUse(state, itemStack)) {
            return IFrameBlock.super.frameUseServer(state, level, pos, player, itemStack, hitresult);
        }
        if (this.lockRedstoneSignal(state, level, pos, player, itemStack) || this.lockOpenClose(state, level, pos, player, itemStack)) {
            return InteractionResult.CONSUME;
        }
        if (((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
            return this.fenceGateBehavior(state, level, pos, player, hitresult);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult fenceGateBehavior(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitresult) {
        LockableFrameTile fenceGateTileEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof LockableFrameTile && (fenceGateTileEntity = (LockableFrameTile)tileEntity).canBeOpenedByPlayers()) {
            super.m_6227_(state, level, pos, player, InteractionHand.MAIN_HAND, hitresult);
            level.m_5898_(null, (Boolean)state.m_61143_((Property)f_53341_) != false ? 1014 : 1008, pos, 0);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    private void convertOutdatedTile(BlockState state, Level level, BlockPos pos, Player player) {
        LockableFrameTile newTile;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!(tileEntity instanceof LockableFrameTile) && tileEntity instanceof FrameBlockTile && (newTile = (LockableFrameTile)this.m_142194_(pos, state)) != null) {
            newTile.addFromOutdatedTileEntity((FrameBlockTile)tileEntity);
            level.m_151523_((BlockEntity)newTile);
            player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.converting_outdated_block"), true);
        }
    }

    private boolean lockRedstoneSignal(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42451_) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof LockableFrameTile) {
                LockableFrameTile doorTileEntity = (LockableFrameTile)tileEntity;
                if (doorTileEntity.canBeOpenedByRedstoneSignal()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.redstone_off"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.redstone_on"), true);
                }
                doorTileEntity.setCanBeOpenedByRedstoneSignal(!doorTileEntity.canBeOpenedByRedstoneSignal());
            } else {
                this.convertOutdatedTile(state, level, pos, player);
            }
            return true;
        }
        return false;
    }

    private boolean lockOpenClose(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42416_) {
            LockableFrameTile newTile;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof LockableFrameTile) {
                LockableFrameTile doorTileEntity = (LockableFrameTile)tileEntity;
                if (doorTileEntity.canBeOpenedByPlayers()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.lock"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.unlock"), true);
                }
                doorTileEntity.setCanBeOpenedByPlayers(!doorTileEntity.canBeOpenedByPlayers());
            } else if (tileEntity instanceof FrameBlockTile && (newTile = (LockableFrameTile)this.m_142194_(pos, state)) != null) {
                newTile.addFromOutdatedTileEntity((FrameBlockTile)tileEntity);
                level.m_151523_((BlockEntity)newTile);
                player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.converting_outdated_block"), true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCorrectTileInstance(BlockEntity blockEntity) {
        return blockEntity instanceof LockableFrameTile;
    }

    @Override
    public void fillBlockEntity(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock, BlockEntity blockEntity) {
        LockableFrameTile frameBlockEntity = (LockableFrameTile)blockEntity;
        frameBlockEntity.clear();
        frameBlockEntity.setMimic(handBlock);
        levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
    }

    public void m_6810_(BlockState state, Level levelIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropContainedBlock(levelIn, pos);
            super.m_6810_(state, levelIn, pos, newState, isMoving);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return IFrameBlock.getLightEmission(state);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor levelIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelIn));
        }
        return super.m_7417_(stateIn, facing, facingState, levelIn, currentPos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockpos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(blockpos);
        BlockState state = super.m_5573_(context);
        if (fluidstate.m_76152_() == Fluids.f_76193_) {
            return (BlockState)Objects.requireNonNull(state).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76170_()));
        }
        return state;
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean update) {
        LockableFrameTile doorTileEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof LockableFrameTile && (doorTileEntity = (LockableFrameTile)tileEntity).canBeOpenedByRedstoneSignal()) {
            super.m_6861_(state, level, pos, block, pos2, update);
        }
    }

    @Override
    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return IFrameBlock.super.canSustainPlant(state, world, pos, facing);
    }

    @Override
    public boolean executeModifications(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        return BlockAppearanceHelper.setAll(itemStack, state, level, pos, player) || this.getTile((BlockGetter)level, pos) != null && BlockModificationHelper.setAll(itemStack, this.getTile((BlockGetter)level, pos), player, true, false);
    }
}

