/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.Objects;
import mod.pianomanu.blockcarpentry.item.BCToolItem;
import mod.pianomanu.blockcarpentry.item.BaseFrameItem;
import mod.pianomanu.blockcarpentry.item.BaseIllusionItem;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.setup.config.BCModConfig;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.IFrameTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.BlockModificationHelper;
import mod.pianomanu.blockcarpentry.util.BlockSavingHelper;
import mod.pianomanu.blockcarpentry.util.ExceptionHandler;
import mod.pianomanu.blockcarpentry.util.FrameInteractionItems;
import mod.pianomanu.blockcarpentry.util.InterModCompat;
import mod.pianomanu.blockcarpentry.util.Tags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.extensions.IForgeBlock;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public interface IFrameBlock
extends IForgeBlock {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final BooleanProperty CONTAINS_BLOCK = BCBlockStateProperties.CONTAINS_BLOCK;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LIGHT_LEVEL = BCBlockStateProperties.LIGHT_LEVEL;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty ENCHANT_POWER = BCBlockStateProperties.ENCHANT_POWER;

    public static int getLightEmission(BlockState state) {
        if ((Integer)state.m_61143_((Property)LIGHT_LEVEL) > 15) {
            return 15;
        }
        return (Integer)state.m_61143_((Property)LIGHT_LEVEL);
    }

    default public boolean shouldCallFrameUse(BlockState state, ItemStack itemStack) {
        return (Boolean)state.m_61143_((Property)CONTAINS_BLOCK) == false || FrameInteractionItems.isModifier(itemStack.m_41720_()) || itemStack.m_41720_() instanceof BCToolItem;
    }

    default public boolean removeBlock(Level level, BlockPos pos, BlockState state, ItemStack itemStack, Player player) {
        if (itemStack.m_41720_() == Registration.HAMMER.get() || !((Boolean)BCModConfig.HAMMER_NEEDED.get()).booleanValue() && player.m_6047_()) {
            if (!player.m_7500_()) {
                this.dropContainedBlock(level, pos);
            } else {
                this.clearTile(level, pos);
            }
            state = (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE);
            level.m_7731_(pos, state, 2);
            return true;
        }
        return false;
    }

    default public void clearTile(Level level, BlockPos pos) {
        FrameBlockTile frameBlockEntity;
        BlockState blockState;
        BlockEntity tileentity;
        if (!level.f_46443_ && (tileentity = level.m_7702_(pos)) instanceof FrameBlockTile && (blockState = (frameBlockEntity = (FrameBlockTile)tileentity).getMimic()) != null) {
            frameBlockEntity.clear();
        }
    }

    default public void dropContainedBlock(Level level, BlockPos pos) {
        FrameBlockTile frameBlockEntity;
        BlockState blockState;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof FrameBlockTile && (blockState = (frameBlockEntity = (FrameBlockTile)blockEntity).getMimic()) != null) {
            this.dropItemStackInWorld(level, pos, blockState);
            frameBlockEntity.clear();
        }
    }

    default public void dropItemStackInWorld(Level level, BlockPos pos, BlockState blockState) {
        level.m_46796_(1010, pos, 0);
        float f = 0.7f;
        double dx = (double)(level.f_46441_.m_188501_() * f) + (double)0.15f;
        double dy = (double)(level.f_46441_.m_188501_() * f) + (double)f;
        double dz = (double)(level.f_46441_.m_188501_() * f) + (double)0.15f;
        ItemStack itemStack = new ItemStack((ItemLike)blockState.m_60734_());
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + dx, (double)pos.m_123342_() + dy, (double)pos.m_123343_() + dz, itemStack);
        itemEntity.m_32060_();
        level.m_7967_((Entity)itemEntity);
    }

    default public void insertBlock(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock) {
        BlockEntity blockEntity = levelIn.m_7702_(pos);
        if (this.isCorrectTileInstance(blockEntity)) {
            this.fillBlockEntity(levelIn, pos, state, handBlock, blockEntity);
        }
    }

    default public void fillBlockEntity(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock, BlockEntity blockEntity) {
        FrameBlockTile frameBlockEntity = (FrameBlockTile)blockEntity;
        frameBlockEntity.clear();
        frameBlockEntity.setMimic(handBlock);
        levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
    }

    default public InteractionResult frameUse(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (!level.f_46443_) {
                return this.frameUseServer(state, level, pos, player, itemStack, hitresult);
            }
            return this.frameUseClient(state, level, pos, player, itemStack, hitresult);
        }
        return InteractionResult.FAIL;
    }

    default public InteractionResult frameUseServer(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack, BlockHitResult hitresult) {
        if (this.removeBlock(level, pos, state, itemStack, player)) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue() && this.executeModifications(state, level, pos, player, itemStack)) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_41720_() instanceof BlockItem && this.changeMimic(state, level, pos, player, itemStack)) {
            return InteractionResult.SUCCESS;
        }
        return itemStack.m_41720_() instanceof BlockItem ? InteractionResult.PASS : InteractionResult.CONSUME;
    }

    default public InteractionResult frameUseClient(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack, BlockHitResult hitresult) {
        Block b;
        if (!(((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue() || !(itemStack.m_41720_() instanceof BlockItem) || BlockSavingHelper.isValidBlock(((BlockItem)itemStack.m_41720_()).m_40614_(), level.f_46443_) || Tags.isFrameBlock(b = ((BlockItem)itemStack.m_41720_()).m_40614_()) || Tags.isIllusionBlock(b))) {
            player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_not_available"), true);
        }
        return itemStack.m_41720_() instanceof BlockItem ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    default public boolean changeMimic(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (((Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() || itemStack.m_41720_() instanceof BaseFrameItem || itemStack.m_41720_() instanceof BaseIllusionItem) {
            return false;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        int count = itemStack.m_41613_();
        Block heldBlock = ((BlockItem)itemStack.m_41720_()).m_40614_();
        if (this.isCorrectTileInstance(blockEntity) && !itemStack.m_41619_() && !((Boolean)state.m_61143_((Property)CONTAINS_BLOCK)).booleanValue()) {
            if (BlockSavingHelper.isValidBlock(heldBlock, level.f_46443_)) {
                BlockState handBlockState = ((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_();
                this.insertBlock(level, pos, state, handBlockState);
                if (!player.m_7500_()) {
                    itemStack.m_41764_(count - 1);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.block_not_available"), true);
            }
        }
        return true;
    }

    default public boolean isCorrectTileInstance(BlockEntity blockEntity) {
        return blockEntity instanceof FrameBlockTile;
    }

    default public <V extends IFrameTile> V getTile(BlockGetter level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        try {
            if (IFrameTile.class.isAssignableFrom(Objects.requireNonNull(be).getClass())) {
                return (V)((IFrameTile)be);
            }
        }
        catch (NullPointerException e) {
            ExceptionHandler.handleException(e);
        }
        return null;
    }

    default public boolean executeModifications(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        try {
            return BlockAppearanceHelper.setAll(itemStack, state, level, pos, player) || this.getTile((BlockGetter)level, pos) != null && BlockModificationHelper.setAll(itemStack, this.getTile((BlockGetter)level, pos), player);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e);
            return false;
        }
    }

    default public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        if (this.getTile((BlockGetter)level, pos) != null) {
            return this.getTile((BlockGetter)level, pos).getFriction().floatValue();
        }
        return super.getFriction(state, level, pos, entity);
    }

    default public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing, IPlantable plantable) {
        return this.canSustainPlant(state, level, pos, facing);
    }

    default public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction facing) {
        if (this.getTile(level, pos) != null) {
            return this.getTile(level, pos).getCanSustainPlant() != false && Block.m_49936_((BlockGetter)level, (BlockPos)pos);
        }
        return false;
    }

    default public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        if (this.getTile(level, pos) != null) {
            return this.getTile(level, pos).getExplosionResistance().floatValue();
        }
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    default public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        if (ModList.get().isLoaded("apotheosis")) {
            if (level.m_5776_()) {
                return InterModCompat.apotheosisEterna(state, level, pos);
            }
            return 0.0f;
        }
        if (this.getTile((BlockGetter)level, pos) != null) {
            return this.getTile((BlockGetter)level, pos).getEnchantPowerBonus().intValue();
        }
        return super.getEnchantPowerBonus(state, level, pos);
    }

    default public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        if (this.getTile(level, pos) != null) {
            return this.getTile(level, pos).getCanEntityDestroy();
        }
        return super.canEntityDestroy(state, level, pos, entity);
    }
}

