/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.item;

import java.util.List;
import java.util.Objects;
import mod.pianomanu.blockcarpentry.item.BCToolItem;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class BlockEntityDebugItem
extends BCToolItem {
    public BlockEntityDebugItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.f_46443_) {
            BlockEntity blockEntity = level.m_7702_(context.m_8083_());
            String blockName = level.m_8055_(context.m_8083_()).m_60734_().m_49954_().getString();
            if (blockEntity != null) {
                Objects.requireNonNull(context.m_43723_()).m_5661_((Component)Component.m_237113_((String)this.formatText(blockEntity.serializeNBT(), blockName)), false);
            } else {
                Objects.requireNonNull(context.m_43723_()).m_5661_((Component)Component.m_237113_((String)("\u00a7bBlock \"\u00a7c" + blockName + "\u00a7b\" does not have a BlockEntity")), false);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> component, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            component.add((Component)Component.m_237115_((String)"tooltip.blockcarpentry.debug_item"));
        } else {
            component.add((Component)Component.m_237115_((String)"tooltip.blockcarpentry.shift"));
        }
    }

    private String formatText(CompoundTag tag, String blockName) {
        StringBuilder formattedText = new StringBuilder("\u00a7bBlock \"\u00a7c" + blockName + "\u00a7b\" has following BlockEntityData:");
        for (String s : tag.m_128431_()) {
            formattedText.append("\n\u00a7d    ").append(s).append("\u00a7f: \u00a76").append(tag.m_128423_(s));
        }
        return formattedText.toString();
    }
}

