/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.MathUtils;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VoxelUtils {
    public static VoxelShape getShape(FrameBlockTile fte) {
        if (fte.shapeUnmodified()) {
            return Shapes.m_83144_();
        }
        Vec3 NWU = new Vec3(fte.NWU.f_82479_, 16.0 + fte.NWU.f_82480_, fte.NWU.f_82481_);
        Vec3 NEU = new Vec3(16.0 + fte.NEU.f_82479_, 16.0 + fte.NEU.f_82480_, fte.NEU.f_82481_);
        Vec3 NWD = new Vec3(fte.NWD.f_82479_, fte.NWD.f_82480_, fte.NWD.f_82481_);
        Vec3 NED = new Vec3(16.0 + fte.NED.f_82479_, fte.NED.f_82480_, fte.NED.f_82481_);
        Vec3 SWU = new Vec3(fte.SWU.f_82479_, 16.0 + fte.SWU.f_82480_, 16.0 + fte.SWU.f_82481_);
        Vec3 SEU = new Vec3(16.0 + fte.SEU.f_82479_, 16.0 + fte.SEU.f_82480_, 16.0 + fte.SEU.f_82481_);
        Vec3 SWD = new Vec3(fte.SWD.f_82479_, fte.SWD.f_82480_, 16.0 + fte.SWD.f_82481_);
        Vec3 SED = new Vec3(16.0 + fte.SED.f_82479_, fte.SED.f_82480_, 16.0 + fte.SED.f_82481_);
        return VoxelUtils.getFreeShape(NWU, SWU, NWD, SWD, NEU, SEU, NED, SED);
    }

    private static VoxelShape getFreeShape(Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED) {
        int maxX = (int)MathUtils.max(NWU.f_82479_, SWU.f_82479_, NWD.f_82479_, SWD.f_82479_, NEU.f_82479_, SEU.f_82479_, NED.f_82479_, SED.f_82479_);
        int minX = (int)MathUtils.min(NWU.f_82479_, SWU.f_82479_, NWD.f_82479_, SWD.f_82479_, NEU.f_82479_, SEU.f_82479_, NED.f_82479_, SED.f_82479_);
        int maxY = (int)MathUtils.max(NWU.f_82480_, SWU.f_82480_, NWD.f_82480_, SWD.f_82480_, NEU.f_82480_, SEU.f_82480_, NED.f_82480_, SED.f_82480_);
        int minY = (int)MathUtils.min(NWU.f_82480_, SWU.f_82480_, NWD.f_82480_, SWD.f_82480_, NEU.f_82480_, SEU.f_82480_, NED.f_82480_, SED.f_82480_);
        int maxZ = (int)MathUtils.max(NWU.f_82481_, SWU.f_82481_, NWD.f_82481_, SWD.f_82481_, NEU.f_82481_, SEU.f_82481_, NED.f_82481_, SED.f_82481_);
        int minZ = (int)MathUtils.min(NWU.f_82481_, SWU.f_82481_, NWD.f_82481_, SWD.f_82481_, NEU.f_82481_, SEU.f_82481_, NED.f_82481_, SED.f_82481_);
        if (maxX == minX) {
            ++maxX;
        }
        if (maxY == minY) {
            ++maxY;
        }
        if (maxZ == minZ) {
            // empty if block
        }
        minX = MathUtils.max(minX, 0);
        minY = MathUtils.max(minY, 0);
        minZ = MathUtils.max(minZ, 0);
        maxX = MathUtils.min(maxX, 16);
        maxY = MathUtils.min(maxY, 16);
        maxZ = MathUtils.min(++maxZ, 16);
        VoxelShape combined = Shapes.m_83040_();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    if (!VoxelUtils.insideBoundaries(new Vec3((double)x, (double)y, (double)z), NWU, SWU, NWD, SWD, NEU, SEU, NED, SED)) continue;
                    combined = Shapes.m_83148_((VoxelShape)combined, (VoxelShape)Block.m_49796_((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)), (BooleanOp)BooleanOp.f_82695_);
                }
            }
        }
        return combined.m_83296_();
    }

    private static boolean insideBoundaries(Vec3 currVec, Vec3 NWU, Vec3 SWU, Vec3 NWD, Vec3 SWD, Vec3 NEU, Vec3 SEU, Vec3 NED, Vec3 SED) {
        Vec3 interpolYhXl = MathUtils.interpolate(NWU, NEU, (currVec.f_82479_ + 0.5) / 16.0, false);
        Vec3 interpolYhXh = MathUtils.interpolate(SWU, SEU, (currVec.f_82479_ + 0.5) / 16.0, false);
        Vec3 interpolYhz = MathUtils.interpolate(interpolYhXl, interpolYhXh, (currVec.f_82481_ + 0.5) / 16.0, false);
        boolean up = interpolYhz.f_82480_ >= currVec.f_82480_ + 0.5;
        Vec3 interpolYlXl = MathUtils.interpolate(NWD, NED, (currVec.f_82479_ + 0.5) / 16.0, false);
        Vec3 interpolYlXh = MathUtils.interpolate(SWD, SED, (currVec.f_82479_ + 0.5) / 16.0, false);
        Vec3 interpolYlz = MathUtils.interpolate(interpolYlXl, interpolYlXh, (currVec.f_82481_ + 0.5) / 16.0, false);
        boolean down = interpolYlz.f_82480_ < currVec.f_82480_ + 0.5;
        Vec3 interpolZlYl = MathUtils.interpolate(NWD, NWU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolZlYh = MathUtils.interpolate(NED, NEU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolZlx = MathUtils.interpolate(interpolZlYl, interpolZlYh, (currVec.f_82479_ + 0.5) / 16.0, false);
        boolean north = interpolZlx.f_82481_ < currVec.f_82481_ + 0.5;
        Vec3 interpolZhYl = MathUtils.interpolate(SWD, SWU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolZhYh = MathUtils.interpolate(SED, SEU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolZhx = MathUtils.interpolate(interpolZhYl, interpolZhYh, (currVec.f_82479_ + 0.5) / 16.0, false);
        boolean south = interpolZhx.f_82481_ >= currVec.f_82481_ + 0.5;
        Vec3 interpolXlYl = MathUtils.interpolate(NWD, NWU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolXlYh = MathUtils.interpolate(SWD, SWU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolXlz = MathUtils.interpolate(interpolXlYl, interpolXlYh, (currVec.f_82481_ + 0.5) / 16.0, false);
        boolean west = interpolXlz.f_82479_ < currVec.f_82479_ + 0.5;
        Vec3 interpolXhYl = MathUtils.interpolate(NED, NEU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolXhYh = MathUtils.interpolate(SED, SEU, (currVec.f_82480_ + 0.5) / 16.0, false);
        Vec3 interpolXhz = MathUtils.interpolate(interpolXhYl, interpolXhYh, (currVec.f_82481_ + 0.5) / 16.0, false);
        boolean east = interpolXhz.f_82479_ >= currVec.f_82479_ + 0.5;
        return up && down && north && south && west && east;
    }
}

