/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.modonomicon.api.ModonomiconAPI;
import com.klikli_dev.modonomicon.api.multiblock.Multiblock;
import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.common.blockentity.SacrificialBowlBlockEntity;
import com.klikli_dev.occultism.common.item.DummyTooltipItem;
import com.klikli_dev.occultism.common.item.spirit.BookOfBindingItem;
import com.klikli_dev.occultism.common.ritual.Ritual;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.klikli_dev.occultism.registry.OccultismParticles;
import com.klikli_dev.occultism.registry.OccultismRecipes;
import com.klikli_dev.occultism.registry.OccultismTiles;
import com.klikli_dev.occultism.util.EntityUtil;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.items.IItemHandler;

public class GoldenSacrificialBowlBlockEntity
extends SacrificialBowlBlockEntity {
    public RitualRecipe currentRitualRecipe;
    public ResourceLocation currentRitualRecipeId;
    public UUID castingPlayerId;
    public Player castingPlayer;
    public List<Ingredient> remainingAdditionalIngredients = new ArrayList<Ingredient>();
    public List<ItemStack> consumedIngredients = new ArrayList<ItemStack>();
    public boolean sacrificeProvided;
    public boolean itemUseProvided;
    public int currentTime;
    public Consumer<PlayerInteractEvent.RightClickItem> rightClickItemListener = this::onPlayerRightClickItem;
    public Consumer<LivingDeathEvent> livingDeathEventListener = this::onLivingDeath;

    public GoldenSacrificialBowlBlockEntity(BlockPos worldPos, BlockState state) {
        super((BlockEntityType)OccultismTiles.GOLDEN_SACRIFICIAL_BOWL.get(), worldPos, state);
    }

    private static boolean helpWithPentacle(Level level, BlockPos pos, Player player) {
        Map<BlockPos, Block> pentacleDiff = null;
        Map<BlockPos, Block> bestPentacleDiff = null;
        List<Multiblock> pentacleMultiblocks = level.m_7465_().m_44013_((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().map(RitualRecipe::getPentacleId).distinct().map(arg_0 -> ((ModonomiconAPI)ModonomiconAPI.get()).getMultiblock(arg_0)).toList();
        Multiblock bestMatch = null;
        for (Multiblock pentacle : pentacleMultiblocks) {
            pentacleDiff = GoldenSacrificialBowlBlockEntity.getDifference(pentacle, level, pos);
            if (bestPentacleDiff != null && bestPentacleDiff.size() <= pentacleDiff.size()) continue;
            bestPentacleDiff = pentacleDiff;
            bestMatch = pentacle;
        }
        if (bestPentacleDiff != null && !bestPentacleDiff.isEmpty() && bestPentacleDiff.size() < 4) {
            player.m_5661_((Component)Component.m_237110_((String)"ritual.occultism.pentacle_help", (Object[])new Object[]{Component.m_237115_((String)Util.m_137492_((String)"multiblock", (ResourceLocation)bestMatch.getId())), GoldenSacrificialBowlBlockEntity.pentacleDiffToComponent(bestPentacleDiff)}), false);
            return true;
        }
        if (bestPentacleDiff != null && !bestPentacleDiff.isEmpty()) {
            player.m_5661_((Component)Component.m_237115_((String)"ritual.occultism.pentacle_help.no_pentacle"), false);
            return true;
        }
        return false;
    }

    private static MutableComponent pentacleDiffToComponent(Map<BlockPos, Block> bestPentacleDiff) {
        MutableComponent text = Component.m_237113_((String)"");
        for (Map.Entry<BlockPos, Block> entry : bestPentacleDiff.entrySet()) {
            text.m_7220_((Component)Component.m_237115_((String)entry.getValue().m_7705_()));
            text.m_7220_((Component)Component.m_237115_((String)"ritual.occultism.pentacle_help_at_glue"));
            BlockPos pos = entry.getKey();
            text.m_7220_((Component)Component.m_237113_((String)("x: " + pos.m_123341_() + ", y: " + pos.m_123342_() + ", z: " + pos.m_123343_() + "\n")));
        }
        return text;
    }

    private static boolean helpWithRitual(Level level, BlockPos pos, Player player, ItemStack activationItem) {
        ArrayList ritualDiff = null;
        ArrayList bestRitualDiff = null;
        RitualRecipe bestRitual = null;
        Stream<Multiblock> pentacleMultiblocks = level.m_7465_().m_44013_((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().map(RitualRecipe::getPentacleId).distinct().map(arg_0 -> ((ModonomiconAPI)ModonomiconAPI.get()).getMultiblock(arg_0));
        Optional<Multiblock> pentacle = pentacleMultiblocks.filter(p -> p.validate(level, pos) != null).findFirst();
        if (pentacle.isEmpty()) {
            return false;
        }
        for (RitualRecipe recipe : level.m_7465_().m_44013_((RecipeType)OccultismRecipes.RITUAL_TYPE.get())) {
            if (recipe.getPentacle() != pentacle.orElseThrow()) continue;
            ritualDiff = new ArrayList(recipe.m_7527_());
            List<ItemStack> items = recipe.getRitual().getItemsOnSacrificialBowls(level, pos);
            boolean found = false;
            for (int i = ritualDiff.size() - 1; i >= 0; --i) {
                found = false;
                for (int j = 0; j < items.size(); ++j) {
                    if (!((Ingredient)ritualDiff.get(i)).test(items.get(j))) continue;
                    items.remove(j);
                    found = true;
                    break;
                }
                if (!found) continue;
                ritualDiff.remove(i);
            }
            if (bestRitualDiff != null && bestRitualDiff.size() <= ritualDiff.size()) continue;
            bestRitualDiff = ritualDiff;
            bestRitual = recipe;
        }
        if (bestRitualDiff != null && !bestRitualDiff.isEmpty() && bestRitualDiff.size() < 4) {
            player.m_5661_((Component)Component.m_237110_((String)"ritual.occultism.ritual_help", (Object[])new Object[]{Component.m_237115_((String)bestRitual.getRitual().getStartedMessage()), GoldenSacrificialBowlBlockEntity.ritualDiffToComponent(bestRitualDiff)}), false);
            return true;
        }
        return false;
    }

    private static Object ritualDiffToComponent(List<Ingredient> ritualDiff) {
        Random rand = new Random();
        MutableComponent text = Component.m_237113_((String)"");
        for (Ingredient ingredient : ritualDiff) {
            if (ingredient.m_43908_().length == 0) continue;
            text.m_7220_(ingredient.m_43908_()[rand.nextInt(ingredient.m_43908_().length)].m_41611_());
            text.m_130946_("\n");
        }
        return text;
    }

    public static Map<BlockPos, Block> getDifference(Multiblock multiblock, Level level, BlockPos pos) {
        HashMap<BlockPos, Block> minDifference = new HashMap<BlockPos, Block>();
        int minDiffSize = Integer.MAX_VALUE;
        for (Rotation rot : Rotation.values()) {
            HashMap<BlockPos, Block> difference = new HashMap<BlockPos, Block>();
            Pair sim = multiblock.simulate(level, pos, rot, false, false);
            for (Multiblock.SimulateResult result : (Collection)sim.getSecond()) {
                if (result.test(level, rot)) continue;
                difference.put(result.getWorldPosition(), result.getStateMatcher().getDisplayedState(0L).m_60734_());
            }
            if (difference.size() >= minDiffSize) continue;
            minDifference = difference;
            minDiffSize = difference.size();
        }
        return minDifference;
    }

    public RitualRecipe getCurrentRitualRecipe() {
        if (this.currentRitualRecipeId != null && this.f_58857_ != null) {
            Optional recipe = this.f_58857_.m_7465_().m_44043_(this.currentRitualRecipeId);
            recipe.map(r -> (RitualRecipe)((Object)r)).ifPresent(r -> {
                this.currentRitualRecipe = r;
            });
            MinecraftForge.EVENT_BUS.addListener(this.rightClickItemListener);
            MinecraftForge.EVENT_BUS.addListener(this.livingDeathEventListener);
            this.currentRitualRecipeId = null;
        }
        return this.currentRitualRecipe;
    }

    public void tick() {
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (!this.f_58857_.f_46443_ && recipe != null) {
            this.restoreCastingPlayer();
            if (this.remainingAdditionalIngredients == null) {
                this.restoreRemainingAdditionalIngredients();
                if (this.remainingAdditionalIngredients == null) {
                    Occultism.LOGGER.warn("Could not restore remainingAdditionalIngredients during tick - level seems to be null. Will attempt again next tick.");
                    return;
                }
            }
            IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            if (!recipe.getRitual().isValid(this.f_58857_, this.m_58899_(), this, this.castingPlayer, handler.getStackInSlot(0), this.remainingAdditionalIngredients)) {
                this.stopRitual(false);
                return;
            }
            if (this.castingPlayer == null || !this.sacrificeFulfilled() || !this.itemUseFulfilled()) {
                if (this.f_58857_.f_46441_.m_188503_(16) == 0) {
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)((SimpleParticleType)OccultismParticles.RITUAL_WAITING.get()), (double)this.m_58899_().m_123341_() + this.f_58857_.f_46441_.m_188583_(), (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + this.f_58857_.f_46441_.m_188583_(), 3, 0.0, 0.0, 0.0, 0.0);
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)((SimpleParticleType)OccultismParticles.RITUAL_WAITING.get()), (double)this.m_58899_().m_123341_() + this.f_58857_.f_46441_.m_188583_(), (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + this.f_58857_.f_46441_.m_188583_(), 3, 0.0, 0.0, 0.0, 0.0);
                }
                return;
            }
            if (this.f_58857_.f_46441_.m_188503_(16) == 0) {
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)this.m_58899_().m_123341_() + 0.5 + this.f_58857_.f_46441_.m_188583_() / 3.0, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5 + this.f_58857_.f_46441_.m_188583_() / 3.0, 5, 0.0, 0.0, 0.0, 0.0);
            }
            if (this.f_58857_.m_46467_() % (long)((int)(20.0 * (Double)Occultism.SERVER_CONFIG.rituals.ritualDurationMultiplier.get())) == 0L) {
                ++this.currentTime;
            }
            recipe.getRitual().update(this.f_58857_, this.m_58899_(), this, this.castingPlayer, handler.getStackInSlot(0), this.currentTime);
            if (!recipe.getRitual().consumeAdditionalIngredients(this.f_58857_, this.m_58899_(), this.remainingAdditionalIngredients, this.currentTime, this.consumedIngredients)) {
                this.stopRitual(false);
                return;
            }
            if (recipe.getDuration() >= 0 && this.currentTime >= recipe.getDuration()) {
                this.stopRitual(true);
            }
        }
    }

    public void restoreCastingPlayer() {
        if (this.castingPlayer == null && this.castingPlayerId != null && this.f_58857_.m_46467_() % 600L == 0L) {
            this.castingPlayer = EntityUtil.getPlayerByUuiDGlobal(this.castingPlayerId).orElse(null);
            this.m_6596_();
            this.markNetworkDirty();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean activate(Level level, BlockPos pos, Player player, InteractionHand hand, Direction face) {
        if (level.f_46443_) return true;
        ItemStack activationItem = player.m_21120_(hand);
        if (activationItem == ItemStack.f_41583_) {
            return false;
        }
        if (activationItem.m_41720_() instanceof DummyTooltipItem) {
            ((DummyTooltipItem)activationItem.m_41720_()).performRitual(level, pos, this, player, activationItem);
            return true;
        }
        if (this.getCurrentRitualRecipe() != null) {
            this.stopRitual(false);
            return true;
        }
        RitualRecipe ritualRecipe = this.f_58857_.m_7465_().m_44013_((RecipeType)OccultismRecipes.RITUAL_TYPE.get()).stream().filter(r -> r.matches(level, pos, activationItem)).findFirst().orElse(null);
        if (ritualRecipe != null) {
            if (ritualRecipe.getRitual().isValid(level, pos, this, player, activationItem, (List<Ingredient>)ritualRecipe.m_7527_())) {
                this.startRitual(player, activationItem, ritualRecipe);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)ritualRecipe.getRitual().getConditionsMessage()), true);
            return false;
        }
        if (activationItem.m_41720_() instanceof BookOfBindingItem) {
            player.m_5661_((Component)Component.m_237115_((String)String.format("ritual.%s.book_not_bound", "occultism")), false);
            return false;
        }
        if (GoldenSacrificialBowlBlockEntity.helpWithPentacle(level, pos, player)) return false;
        if (GoldenSacrificialBowlBlockEntity.helpWithRitual(level, pos, player, activationItem)) return false;
        player.m_5661_((Component)Component.m_237115_((String)String.format("ritual.%s.does_not_exist", "occultism")), false);
        return false;
    }

    public void startRitual(Player player, ItemStack activationItem, RitualRecipe ritualRecipe) {
        if (!this.f_58857_.f_46443_) {
            this.currentRitualRecipe = ritualRecipe;
            this.castingPlayerId = player.m_20148_();
            this.castingPlayer = player;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            this.consumedIngredients.clear();
            this.remainingAdditionalIngredients = new ArrayList<Ingredient>((Collection<Ingredient>)this.currentRitualRecipe.m_7527_());
            IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
            handler.insertItem(0, activationItem.m_41620_(1), false);
            this.currentRitualRecipe.getRitual().start(this.f_58857_, this.m_58899_(), this, player, handler.getStackInSlot(0));
            MinecraftForge.EVENT_BUS.addListener(this.rightClickItemListener);
            MinecraftForge.EVENT_BUS.addListener(this.livingDeathEventListener);
            this.m_6596_();
            this.markNetworkDirty();
        }
    }

    public void stopRitual(boolean finished) {
        if (!this.f_58857_.f_46443_) {
            RitualRecipe recipe = this.getCurrentRitualRecipe();
            if (recipe != null && this.castingPlayer != null) {
                IItemHandler handler = (IItemHandler)this.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
                if (finished) {
                    ItemStack activationItem = handler.getStackInSlot(0);
                    recipe.getRitual().finish(this.f_58857_, this.m_58899_(), this, this.castingPlayer, activationItem);
                } else {
                    recipe.getRitual().interrupt(this.f_58857_, this.m_58899_(), this, this.castingPlayer, handler.getStackInSlot(0));
                    Containers.m_18992_((Level)this.f_58857_, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), (ItemStack)handler.extractItem(0, 1, false));
                }
            }
            this.currentRitualRecipe = null;
            this.castingPlayerId = null;
            this.castingPlayer = null;
            this.currentTime = 0;
            this.sacrificeProvided = false;
            this.itemUseProvided = false;
            if (this.remainingAdditionalIngredients != null) {
                this.remainingAdditionalIngredients.clear();
            }
            this.consumedIngredients.clear();
            MinecraftForge.EVENT_BUS.unregister(this.rightClickItemListener);
            MinecraftForge.EVENT_BUS.unregister(this.livingDeathEventListener);
            this.m_6596_();
            this.markNetworkDirty();
        }
    }

    public boolean sacrificeFulfilled() {
        return !this.getCurrentRitualRecipe().requiresSacrifice() || this.sacrificeProvided;
    }

    public boolean itemUseFulfilled() {
        return !this.getCurrentRitualRecipe().requiresItemUse() || this.itemUseProvided;
    }

    public void notifySacrifice(LivingEntity entityLivingBase) {
        this.sacrificeProvided = true;
    }

    public void notifyItemUse(PlayerInteractEvent.RightClickItem event) {
        this.itemUseProvided = true;
    }

    public void onPlayerRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (!player.f_19853_.f_46443_ && this.getCurrentRitualRecipe() != null && this.m_58899_().m_123331_((Vec3i)event.getPos()) <= 256.0 && this.getCurrentRitualRecipe().getRitual().isValidItemUse(event)) {
            this.notifyItemUse(event);
        }
    }

    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entityLivingBase = event.getEntity();
        if (!entityLivingBase.f_19853_.f_46443_ && this.getCurrentRitualRecipe() != null && event.getSource().m_7639_() instanceof Player && this.m_58899_().m_123331_((Vec3i)entityLivingBase.m_20183_()) <= 64.0 && this.getCurrentRitualRecipe().getRitual().isValidSacrifice(entityLivingBase)) {
            this.notifySacrifice(entityLivingBase);
        }
    }

    protected void restoreRemainingAdditionalIngredients() {
        this.remainingAdditionalIngredients = this.f_58857_ == null ? null : (this.consumedIngredients.size() > 0 ? Ritual.getRemainingAdditionalIngredients((List<Ingredient>)this.getCurrentRitualRecipe().m_7527_(), this.consumedIngredients) : new ArrayList<Ingredient>((Collection<Ingredient>)this.getCurrentRitualRecipe().m_7527_()));
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.consumedIngredients.clear();
        if (this.currentRitualRecipeId != null || this.getCurrentRitualRecipe() != null) {
            if (compound.m_128441_("consumedIngredients")) {
                ListTag list = compound.m_128437_("consumedIngredients", 10);
                for (int i = 0; i < list.size(); ++i) {
                    ItemStack stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(i));
                    this.consumedIngredients.add(stack);
                }
            }
            this.restoreRemainingAdditionalIngredients();
        }
        if (compound.m_128441_("sacrificeProvided")) {
            this.sacrificeProvided = compound.m_128471_("sacrificeProvided");
        }
        if (compound.m_128441_("requiredItemUsed")) {
            this.itemUseProvided = compound.m_128471_("requiredItemUsed");
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        if (this.getCurrentRitualRecipe() != null) {
            if (this.consumedIngredients.size() > 0) {
                ListTag list = new ListTag();
                for (ItemStack stack : this.consumedIngredients) {
                    list.add((Object)stack.serializeNBT());
                }
                compound.m_128365_("consumedIngredients", (Tag)list);
            }
            compound.m_128379_("sacrificeProvided", this.sacrificeProvided);
            compound.m_128379_("requiredItemUsed", this.itemUseProvided);
        }
        super.m_183515_(compound);
    }

    @Override
    public void loadNetwork(CompoundTag compound) {
        super.loadNetwork(compound);
        if (compound.m_128441_("currentRitual")) {
            this.currentRitualRecipeId = new ResourceLocation(compound.m_128461_("currentRitual"));
        }
        if (compound.m_128441_("castingPlayerId")) {
            this.castingPlayerId = compound.m_128342_("castingPlayerId");
        }
        this.currentTime = compound.m_128451_("currentTime");
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound) {
        RitualRecipe recipe = this.getCurrentRitualRecipe();
        if (recipe != null) {
            compound.m_128359_("currentRitual", recipe.m_6423_().toString());
        }
        if (this.castingPlayerId != null) {
            compound.m_128362_("castingPlayerId", this.castingPlayerId);
        }
        compound.m_128405_("currentTime", this.currentTime);
        return super.saveNetwork(compound);
    }
}

