/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.blockentity;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.api.common.blockentity.IStorageAccessor;
import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.blockentity.IStorageControllerProxy;
import com.klikli_dev.occultism.api.common.container.IItemStackComparator;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.api.common.data.MachineReference;
import com.klikli_dev.occultism.api.common.data.SortDirection;
import com.klikli_dev.occultism.api.common.data.SortType;
import com.klikli_dev.occultism.common.block.storage.StorageStabilizerBlock;
import com.klikli_dev.occultism.common.blockentity.NetworkedBlockEntity;
import com.klikli_dev.occultism.common.container.storage.StorageControllerContainer;
import com.klikli_dev.occultism.common.entity.job.ManageMachineJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.common.misc.DepositOrder;
import com.klikli_dev.occultism.common.misc.ItemStackComparator;
import com.klikli_dev.occultism.common.misc.StorageControllerItemStackHandler;
import com.klikli_dev.occultism.network.MessageUpdateStacks;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismTiles;
import com.klikli_dev.occultism.util.EntityUtil;
import com.klikli_dev.occultism.util.Math3DUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.builder.ILoopType;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class StorageControllerBlockEntity
extends NetworkedBlockEntity
implements MenuProvider,
IStorageController,
IStorageAccessor,
IStorageControllerProxy,
IAnimatable {
    public static final int MAX_STABILIZER_DISTANCE = 5;
    protected static final List<RegistryObject<? extends Block>> BLOCK_BLACKLIST = Stream.of(OccultismBlocks.STORAGE_CONTROLLER).collect(Collectors.toList());
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public Map<Integer, ItemStack> matrix = new HashMap<Integer, ItemStack>();
    public ItemStack orderStack = ItemStack.f_41583_;
    public Map<GlobalBlockPos, MachineReference> linkedMachines = new HashMap<GlobalBlockPos, MachineReference>();
    public Map<GlobalBlockPos, UUID> depositOrderSpirits = new HashMap<GlobalBlockPos, UUID>();
    protected SortDirection sortDirection = SortDirection.DOWN;
    protected SortType sortType = SortType.AMOUNT;
    protected ItemStackHandler itemStackHandlerInternal;
    protected LazyOptional<ItemStackHandler> itemStackHandler;
    protected int maxSlots;
    protected int usedSlots;
    protected boolean stabilizersInitialized;
    protected GlobalBlockPos globalPos;
    protected MessageUpdateStacks cachedMessageUpdateStacks;

    public StorageControllerBlockEntity(BlockPos worldPos, BlockState state) {
        super((BlockEntityType)OccultismTiles.STORAGE_CONTROLLER.get(), worldPos, state);
        this.itemStackHandlerInternal = new StorageControllerItemStackHandler(this, (Integer)Occultism.SERVER_CONFIG.storage.controllerBaseSlots.get(), (Integer)Occultism.SERVER_CONFIG.storage.controllerStackSize.get(), (Boolean)Occultism.SERVER_CONFIG.storage.overrideItemStackSizes.get());
        this.itemStackHandler = LazyOptional.of(() -> this.itemStackHandlerInternal);
        this.maxSlots = (Integer)Occultism.SERVER_CONFIG.storage.controllerBaseSlots.get();
        this.usedSlots = 0;
        this.stabilizersInitialized = false;
    }

    public void tick() {
        if (!this.f_58857_.f_46443_ && !this.stabilizersInitialized) {
            this.stabilizersInitialized = true;
            this.updateStabilizers();
        }
    }

    public void updateStabilizers() {
        int additionalSlots = 0;
        List<BlockPos> stabilizerLocations = this.findValidStabilizers();
        for (BlockPos pos : stabilizerLocations) {
            additionalSlots += this.getSlotsForStabilizer(this.f_58857_.m_8055_(pos));
        }
        this.setMaxSlots((Integer)Occultism.SERVER_CONFIG.storage.controllerBaseSlots.get() + additionalSlots);
    }

    public List<BlockPos> findValidStabilizers() {
        ArrayList<BlockPos> validStabilizers = new ArrayList<BlockPos>();
        BlockPos up = this.m_58899_().m_7494_();
        for (Direction face : Direction.values()) {
            BlockState state;
            BlockPos hit = Math3DUtil.simpleTrace(up, face, 5, pos -> {
                BlockState state = this.f_58857_.m_8055_(pos);
                return state.m_60734_() instanceof StorageStabilizerBlock;
            });
            if (hit == null || (state = this.f_58857_.m_8055_(hit)).m_61143_((Property)DirectionalBlock.f_52588_) != face.m_122424_()) continue;
            validStabilizers.add(hit);
        }
        return validStabilizers;
    }

    protected int getSlotsForStabilizer(BlockState state) {
        Block block = state.m_60734_();
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER1.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier1Slots.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER2.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier2Slots.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER3.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier3Slots.get();
        }
        if (block == OccultismBlocks.STORAGE_STABILIZER_TIER4.get()) {
            return (Integer)Occultism.SERVER_CONFIG.storage.stabilizerTier4Slots.get();
        }
        return 0;
    }

    protected void mergeIntoList(List<ItemStack> list, ItemStack stackToAdd) {
        boolean merged = false;
        for (ItemStack stack : list) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stackToAdd, (ItemStack)stack)) continue;
            stack.m_41764_(stack.m_41613_() + stackToAdd.m_41613_());
            merged = true;
            break;
        }
        if (!merged) {
            list.add(stackToAdd);
        }
    }

    protected void validateLinkedMachines() {
        this.linkedMachines.entrySet().removeIf(entry -> !((MachineReference)entry.getValue()).isValidFor(this.f_58857_));
    }

    private List<Predicate<ItemStack>> getComparatorsSortedByAmount(Predicate<ItemStack> comparator) {
        ItemStackHandler handler = this.itemStackHandlerInternal;
        HashMap<Item, Integer> map = new HashMap<Item, Integer>();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack getStackInSlot = handler.getStackInSlot(i);
            if (!comparator.test(getStackInSlot)) continue;
            Integer oldCount = map.getOrDefault(getStackInSlot.m_41720_(), 0);
            map.put(getStackInSlot.m_41720_(), oldCount + getStackInSlot.m_41613_());
        }
        return map.entrySet().stream().sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).map(entry -> stack -> stack.m_41720_() == entry.getKey()).toList();
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.dimensional_matrix.new", (ILoopType)ILoopType.EDefaultLoopTypes.LOOP));
        return PlayState.CONTINUE;
    }

    public Component m_5446_() {
        return Component.m_237113_((String)ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)this.m_58903_()).m_135815_());
    }

    @Override
    public IStorageController getLinkedStorageController() {
        return this;
    }

    @Override
    public GlobalBlockPos getLinkedStorageControllerPosition() {
        if (this.globalPos == null) {
            this.globalPos = new GlobalBlockPos(this.m_58899_(), this.f_58857_);
        }
        return this.globalPos;
    }

    @Override
    public void setLinkedStorageControllerPosition(GlobalBlockPos blockPos) {
    }

    @Override
    public Map<Integer, ItemStack> getMatrix() {
        return this.matrix;
    }

    @Override
    public ItemStack getOrderStack() {
        return this.orderStack;
    }

    @Override
    public void setOrderStack(@Nonnull ItemStack stack) {
        this.orderStack = stack;
    }

    @Override
    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    @Override
    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    @Override
    public SortType getSortType() {
        return this.sortType;
    }

    @Override
    public void setSortType(SortType sortType) {
        this.sortType = sortType;
    }

    @Override
    public List<ItemStack> getStacks() {
        ItemStackHandler handler = this.itemStackHandlerInternal;
        int size = handler.getSlots();
        int usedSlots = 0;
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(size);
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            ++usedSlots;
            this.mergeIntoList(result, stack.m_41777_());
        }
        this.usedSlots = usedSlots;
        return result;
    }

    @Override
    public MessageUpdateStacks getMessageUpdateStacks() {
        if (this.cachedMessageUpdateStacks == null) {
            List<ItemStack> stacks = this.getStacks();
            this.cachedMessageUpdateStacks = new MessageUpdateStacks(stacks, this.getUsedSlots(), this.getMaxSlots());
        }
        return this.cachedMessageUpdateStacks;
    }

    @Override
    public int getMaxSlots() {
        return this.maxSlots;
    }

    @Override
    public void setMaxSlots(int slots) {
        this.maxSlots = slots;
        this.itemStackHandlerInternal.setSize(this.maxSlots);
        this.cachedMessageUpdateStacks = null;
        this.markNetworkDirty();
    }

    @Override
    public int getUsedSlots() {
        return this.usedSlots;
    }

    @Override
    public Map<GlobalBlockPos, MachineReference> getLinkedMachines() {
        return this.linkedMachines;
    }

    @Override
    public void setLinkedMachines(Map<GlobalBlockPos, MachineReference> machines) {
        this.linkedMachines = machines;
    }

    @Override
    public void linkMachine(MachineReference machine) {
        this.linkedMachines.put(machine.insertGlobalPos, machine);
    }

    @Override
    public void addDepositOrder(GlobalBlockPos linkedMachinePosition, IItemStackComparator comparator, int amount) {
        ItemStack stack = this.getItemStack(comparator, amount, true);
        if (!stack.m_41619_()) {
            UUID spiritUUID = this.depositOrderSpirits.get(linkedMachinePosition);
            if (spiritUUID != null) {
                EntityUtil.getEntityByUuiDGlobal(this.f_58857_.m_7654_(), spiritUUID).filter(SpiritEntity.class::isInstance).map(SpiritEntity.class::cast).ifPresent(spirit -> {
                    Optional<ManageMachineJob> job = spirit.getJob().filter(ManageMachineJob.class::isInstance).map(ManageMachineJob.class::cast);
                    if (job.isPresent()) {
                        job.get().addDepsitOrder(new DepositOrder((ItemStackComparator)comparator, amount));
                    } else {
                        this.removeDepositOrderSpirit(linkedMachinePosition);
                    }
                });
            } else {
                this.removeDepositOrderSpirit(linkedMachinePosition);
            }
        }
    }

    @Override
    public void addDepositOrderSpirit(GlobalBlockPos linkedMachinePosition, UUID spiritId) {
        this.depositOrderSpirits.put(linkedMachinePosition, spiritId);
    }

    @Override
    public void removeDepositOrderSpirit(GlobalBlockPos linkedMachinePosition) {
        this.linkedMachines.remove(linkedMachinePosition);
        this.depositOrderSpirits.remove(linkedMachinePosition);
    }

    @Override
    public boolean isBlacklisted(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem itemBlock = (BlockItem)item;
            return BLOCK_BLACKLIST.stream().map(RegistryObject::get).anyMatch(block -> itemBlock.m_40614_() == block);
        }
        return stack.m_41720_() == OccultismItems.STORAGE_REMOTE.get();
    }

    @Override
    public int insertStack(ItemStack stack, boolean simulate) {
        if (this.isBlacklisted(stack)) {
            return stack.m_41613_();
        }
        ItemStackHandler handler = this.itemStackHandlerInternal;
        if (ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true).m_41613_() < stack.m_41613_()) {
            stack = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack.m_41613_();
    }

    @Override
    public ItemStack getOneOfMostCommonItem(Predicate<ItemStack> comparator, boolean simulate) {
        if (comparator == null) {
            return ItemStack.f_41583_;
        }
        List<Predicate<ItemStack>> comparators = this.getComparatorsSortedByAmount(comparator);
        ItemStackHandler handler = this.itemStackHandlerInternal;
        for (Predicate<ItemStack> currentComparator : comparators) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.extractItem(slot, 1, true);
                if (stack.m_41619_() || !currentComparator.test(stack)) continue;
                return handler.extractItem(slot, 1, simulate);
            }
        }
        return ItemStack.f_41583_;
    }

    @Override
    public ItemStack getItemStack(Predicate<ItemStack> comparator, int requestedSize, boolean simulate) {
        if (requestedSize <= 0 || comparator == null) {
            return ItemStack.f_41583_;
        }
        ItemStackHandler handler = this.itemStackHandlerInternal;
        ItemStack firstMatchedStack = ItemStack.f_41583_;
        int remaining = requestedSize;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.extractItem(slot, remaining, true);
            if (stack.m_41619_()) continue;
            if (firstMatchedStack.m_41619_()) {
                if (!comparator.test(stack)) continue;
                firstMatchedStack = stack.m_41777_();
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)firstMatchedStack, (ItemStack)stack)) continue;
            int toExtract = Math.min(stack.m_41613_(), remaining);
            ItemStack extractedStack = handler.extractItem(slot, toExtract, simulate);
            if ((remaining -= extractedStack.m_41613_()) <= 0) break;
        }
        int extractCount = requestedSize - remaining;
        if (!firstMatchedStack.m_41619_() && extractCount > 0) {
            firstMatchedStack.m_41764_(extractCount);
        }
        return firstMatchedStack;
    }

    @Override
    public int getAvailableAmount(IItemStackComparator comparator) {
        if (comparator == null) {
            return 0;
        }
        int totalCount = 0;
        ItemStackHandler handler = this.itemStackHandlerInternal;
        int size = handler.getSlots();
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (!comparator.matches(stack)) continue;
            totalCount += stack.m_41613_();
        }
        return totalCount;
    }

    @Override
    public void onContentsChanged() {
        this.cachedMessageUpdateStacks = null;
        this.m_6596_();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemStackHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemStackHandler = LazyOptional.of(() -> this.itemStackHandlerInternal);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemStackHandler.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        compound.m_128473_("linkedMachines");
        super.m_142466_(compound);
        if (compound.m_128441_("items")) {
            this.itemStackHandlerInternal.deserializeNBT(compound.m_128469_("items"));
            this.cachedMessageUpdateStacks = null;
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128473_("linkedMachines");
        compound.m_128365_("items", (Tag)this.itemStackHandlerInternal.serializeNBT());
    }

    @Override
    public void loadNetwork(CompoundTag compound) {
        int i;
        this.setSortDirection(SortDirection.get(compound.m_128451_("sortDirection")));
        this.setSortType(SortType.get(compound.m_128451_("sortType")));
        if (compound.m_128441_("maxSlots")) {
            this.setMaxSlots(compound.m_128451_("maxSlots"));
        }
        this.matrix = new HashMap<Integer, ItemStack>();
        if (compound.m_128441_("matrix")) {
            ListTag matrixNbt = compound.m_128437_("matrix", 10);
            for (i = 0; i < matrixNbt.size(); ++i) {
                CompoundTag stackTag = matrixNbt.m_128728_(i);
                byte slot = stackTag.m_128445_("slot");
                ItemStack s = ItemStack.m_41712_((CompoundTag)stackTag);
                this.matrix.put(Integer.valueOf(slot), s);
            }
        }
        if (compound.m_128441_("orderStack")) {
            this.orderStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("orderStack"));
        }
        this.linkedMachines = new HashMap<GlobalBlockPos, MachineReference>();
        if (compound.m_128441_("linkedMachines")) {
            ListTag machinesNbt = compound.m_128437_("linkedMachines", 10);
            for (i = 0; i < machinesNbt.size(); ++i) {
                MachineReference reference = MachineReference.from(machinesNbt.m_128728_(i));
                this.linkedMachines.put(reference.insertGlobalPos, reference);
            }
        }
    }

    @Override
    public CompoundTag saveNetwork(CompoundTag compound) {
        compound.m_128405_("sortDirection", this.getSortDirection().getValue());
        compound.m_128405_("sortType", this.getSortType().getValue());
        compound.m_128405_("maxSlots", this.maxSlots);
        ListTag matrixNbt = new ListTag();
        for (int i = 0; i < 9; ++i) {
            if (this.matrix.get(i) == null || this.matrix.get(i).m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128344_("slot", (byte)i);
            this.matrix.get(i).m_41739_(stackTag);
            matrixNbt.add((Object)stackTag);
        }
        compound.m_128365_("matrix", (Tag)matrixNbt);
        if (!this.orderStack.m_41619_()) {
            compound.m_128365_("orderStack", (Tag)this.orderStack.m_41739_(new CompoundTag()));
        }
        ListTag machinesNbt = new ListTag();
        for (Map.Entry<GlobalBlockPos, MachineReference> entry : this.linkedMachines.entrySet()) {
            machinesNbt.add((Object)entry.getValue().serializeNBT());
        }
        compound.m_128365_("linkedMachines", (Tag)machinesNbt);
        return compound;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new StorageControllerContainer(id, playerInventory, this);
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

