/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.goal;

import com.google.common.base.Predicate;
import com.klikli_dev.occultism.common.entity.ai.EntitySorter;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class PickupItemsGoal
extends TargetGoal {
    protected final SpiritEntity entity;
    protected final Predicate<? super ItemEntity> targetItemSelector;
    protected final EntitySorter entitySorter;
    protected ItemEntity targetItem;
    protected int executionChance;
    protected float pickupRange;

    public PickupItemsGoal(SpiritEntity entity) {
        this(entity, 2.0f, 10);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public PickupItemsGoal(final SpiritEntity entity, float pickupRange, int executionChance) {
        super((Mob)entity, false, false);
        this.entity = entity;
        this.pickupRange = pickupRange;
        this.executionChance = executionChance;
        this.targetItemSelector = new Predicate<ItemEntity>(){

            public boolean apply(@Nullable ItemEntity item) {
                ItemStack stack = item.m_32055_();
                return !stack.m_41619_() && entity.canPickupItem(item) && ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)entity.itemStackHandler.orElseThrow(ItemHandlerMissingException::new)), (ItemStack)stack, (boolean)true).m_41613_() < stack.m_41613_();
            }
        };
        this.entitySorter = new EntitySorter((Entity)entity);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        long worldTime = this.f_26135_.f_19853_.m_46467_() % 10L;
        if (this.entity.m_21216_() >= 100 && worldTime != 0L) {
            return false;
        }
        if (this.executionChance > 0 && this.entity.m_217043_().m_188503_(this.executionChance) != 0 && worldTime != 0L) {
            return false;
        }
        int workAreaSize = this.entity.getWorkAreaSize().getValue();
        AABB targetBox = new AABB((double)(-workAreaSize), (double)(-workAreaSize) / 2.0, (double)(-workAreaSize), (double)workAreaSize, (double)workAreaSize / 2.0, (double)workAreaSize).m_82338_(this.entity.getWorkAreaCenter());
        List list = this.f_26135_.f_19853_.m_6443_(ItemEntity.class, targetBox, this.targetItemSelector);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.entitySorter);
        this.targetItem = (ItemEntity)list.get(0);
        return true;
    }

    public void m_8037_() {
        if (this.targetItem == null || !this.targetItem.m_6084_()) {
            this.m_8041_();
            this.f_26135_.m_21573_().m_26573_();
        } else {
            this.f_26135_.m_21573_().m_26536_(this.f_26135_.m_21573_().m_6570_((Entity)this.targetItem, 0), 1.0);
            double distance = this.entity.m_20182_().m_82554_(this.targetItem.m_20182_());
            if (distance < (double)this.pickupRange) {
                this.entity.m_20334_(0.0, 0.0, 0.0);
                this.entity.m_21573_().m_26573_();
                ItemStack duplicate = this.targetItem.m_32055_().m_41777_();
                ItemStackHandler handler = (ItemStackHandler)this.entity.itemStackHandler.orElseThrow(ItemHandlerMissingException::new);
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)true).m_41613_() < duplicate.m_41613_()) {
                    ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)duplicate, (boolean)false);
                    this.targetItem.m_32055_().m_41764_(remaining.m_41613_());
                }
            }
        }
    }

    public boolean m_8045_() {
        return !this.f_26135_.m_21573_().m_26571_();
    }

    public void m_8056_() {
        this.f_26135_.m_21573_().m_26536_(this.f_26135_.m_21573_().m_6570_((Entity)this.targetItem, 0), 1.0);
        super.m_8056_();
    }
}

