/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.DevilFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.GreedyFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.ThrownSwordEntity;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEffects;
import com.klikli_dev.occultism.registry.OccultismEntities;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.items.ItemHandlerHelper;

public class DragonFamiliarEntity
extends FamiliarEntity {
    public static final int MAX_PET_TIMER = 40;
    private static final int GREEDY_INCREMENT = 6000;
    private final float colorOffset = this.m_217043_().m_188501_() * 2.0f;
    private int greedyTimer;
    private int flyingTimer;
    private int flyingTimer0;
    private int wingspan;
    private int wingspan0;
    private int petTimer = 40;

    public DragonFamiliarEntity(EntityType<? extends DragonFamiliarEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.m_21552_().m_22268_(Attributes.f_22281_, 4.0);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasFez()) {
            OccultismAdvancements.FAMILIAR.trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setFez(this.m_217043_().m_188500_() < 0.1);
        this.setEars(this.m_217043_().m_188500_() < 0.5);
        this.setArms(this.m_217043_().m_188500_() < 0.5);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    public boolean hasSword() {
        return this.hasBlacksmithUpgrade() && !this.f_20911_;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new GreedyFamiliarEntity.FindItemGoal(this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && DragonFamiliarEntity.this.m_20197_().stream().anyMatch(e -> e instanceof GreedyFamiliarEntity);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new FetchGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.f_21345_.m_25352_(6, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !DragonFamiliarEntity.this.hasBlacksmithUpgrade();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new ThrowSwordGoal(this, 100.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void m_21011_(InteractionHand handIn, boolean updateSelf) {
        super.m_21011_(handIn, updateSelf);
        this.f_20913_ = -14;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public float getAttackProgress(float partialTicks) {
        return Mth.m_14179_((float)(((float)(this.f_20913_ + 14) + partialTicks) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public int getPetTimer() {
        return this.petTimer;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.greedyTimer > 0) {
            --this.greedyTimer;
        }
        if (!this.m_20096_()) {
            Vec3 motion = this.m_20184_();
            if (motion.f_82480_ < 0.0) {
                motion = motion.m_82542_(1.0, 0.5, 1.0);
                this.m_20256_(motion);
            }
        }
        if (!this.m_6142_()) {
            this.flyingTimer0 = this.flyingTimer++;
            this.wingspan0 = this.wingspan;
            if (this.m_20096_()) {
                this.wingspan -= 5;
                if (this.wingspan < 0) {
                    this.wingspan = 0;
                }
            } else {
                this.wingspan += 5;
                if (this.wingspan > 30) {
                    this.wingspan = 30;
                }
            }
            if (this.petTimer < 40) {
                ++this.petTimer;
            }
        }
    }

    public float getFlyingTimer(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.flyingTimer0, (float)this.flyingTimer);
    }

    public float getWingspan(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.wingspan0, (float)this.wingspan);
    }

    @Override
    protected InteractionResult m_6071_(Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.m_21120_(hand);
        if (this.hasStick()) {
            ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)new ItemStack((ItemLike)Items.f_42398_));
            this.setStick(false);
            return InteractionResult.m_19078_((!this.m_6142_() ? 1 : 0) != 0);
        }
        if (stack.m_204117_(Tags.Items.NUGGETS_GOLD)) {
            OccultismAdvancements.FAMILIAR.trigger(this.getFamiliarOwner(), FamiliarTrigger.Type.DRAGON_NUGGET);
            this.greedyTimer += 6000;
            if (this.m_6142_()) {
                stack.m_41774_(1);
            } else {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            return InteractionResult.m_19078_((!this.m_6142_() ? 1 : 0) != 0);
        }
        if (stack.m_41619_() && playerIn.m_6144_()) {
            this.petTimer = 0;
            OccultismAdvancements.FAMILIAR.trigger((LivingEntity)playerIn, FamiliarTrigger.Type.DRAGON_PET);
            return InteractionResult.m_19078_((!this.m_6142_() ? 1 : 0) != 0);
        }
        return super.m_6071_(playerIn, hand);
    }

    public boolean hasFez() {
        return this.hasVariant(0);
    }

    private void setFez(boolean b) {
        this.setVariant(0, b);
    }

    public boolean hasEars() {
        return this.hasVariant(1);
    }

    private void setEars(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasArms() {
        return this.hasVariant(2);
    }

    private void setArms(boolean b) {
        this.setVariant(2, b);
    }

    public boolean hasStick() {
        return this.hasVariant(3);
    }

    private void setStick(boolean b) {
        this.setVariant(3, b);
    }

    public double m_6048_() {
        return super.m_6048_() * (double)0.4f;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("greedyTimer", this.greedyTimer);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (!compound.m_128441_("variants")) {
            this.setFez(compound.m_128471_("hasFez"));
            this.setEars(compound.m_128471_("hasEars"));
            this.setArms(compound.m_128471_("hasArms"));
            this.setStick(compound.m_128471_("hasStick"));
        }
        this.greedyTimer = compound.m_128451_("greedyTimer");
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of((Object)new MobEffectInstance((MobEffect)OccultismEffects.DRAGON_GREED.get(), 300, this.greedyTimer > 0 ? 1 : 0, false, false));
    }

    public float getEyeColorR(float partialTicks) {
        return Math.abs(Mth.m_14031_((float)(((float)this.f_19797_ + partialTicks + 5.0f) / 20.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    public float getEyeColorG(float partialTicks) {
        return Math.abs(Mth.m_14031_((float)(((float)this.f_19797_ + partialTicks + 10.0f) / 30.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    public float getEyeColorB(float partialTicks) {
        return Math.abs(Mth.m_14031_((float)(((float)this.f_19797_ + partialTicks) / 40.0f + this.colorOffset))) * 0.8f + 0.2f;
    }

    private static class FetchGoal
    extends Goal {
        private final DragonFamiliarEntity dragon;
        private ItemEntity stick;

        public FetchGoal(DragonFamiliarEntity dragon) {
            this.dragon = dragon;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            this.stick = this.findStick();
            return this.stick != null && !this.dragon.hasStick();
        }

        public boolean m_8045_() {
            return this.stick != null && !this.dragon.hasStick();
        }

        public void m_8056_() {
            this.dragon.m_21573_().m_5624_((Entity)this.stick, 1.2);
        }

        public void m_8041_() {
            this.dragon.m_21573_().m_26573_();
            this.stick = null;
        }

        public void m_8037_() {
            if (this.stick == null || !this.stick.m_6084_()) {
                this.stick = this.findStick();
                if (this.stick == null) {
                    return;
                }
            }
            this.dragon.m_21573_().m_5624_((Entity)this.stick, 1.2);
            if (this.stick.m_20280_((Entity)this.dragon) < 3.0) {
                this.dragon.setStick(true);
                OccultismAdvancements.FAMILIAR.trigger(this.dragon.getFamiliarOwner(), FamiliarTrigger.Type.DRAGON_FETCH);
                this.stick.m_32055_().m_41774_(1);
                this.stick = null;
            }
        }

        private ItemEntity findStick() {
            List sticks = this.dragon.f_19853_.m_6443_(ItemEntity.class, this.dragon.m_20191_().m_82400_(8.0), e -> e.m_32055_().m_41720_() == Items.f_42398_ && e.m_6084_());
            return sticks.isEmpty() ? null : (ItemEntity)sticks.get(0);
        }
    }

    private static class ThrowSwordGoal
    extends DevilFamiliarEntity.AttackGoal {
        public ThrowSwordGoal(FamiliarEntity entity, float range) {
            super(entity, range);
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && this.entity.hasBlacksmithUpgrade();
        }

        @Override
        protected void attack(List<LivingEntity> enemies) {
            if (enemies.isEmpty()) {
                return;
            }
            Entity enemy = (Entity)enemies.get(this.entity.m_217043_().m_188503_(enemies.size()));
            ThrownSwordEntity sword = new ThrownSwordEntity((EntityType<? extends ThrownSwordEntity>)((EntityType)OccultismEntities.THROWN_SWORD_TYPE.get()), this.entity.f_19853_);
            sword.m_5602_((Entity)this.entity.getFamiliarOwner());
            double x = this.entity.m_20185_();
            double y = this.entity.m_20188_();
            double z = this.entity.m_20189_();
            double xDir = enemy.m_20185_() - x;
            double yDir = enemy.m_20186_() + (double)enemy.m_20206_() - y;
            double zDir = enemy.m_20189_() - z;
            sword.m_6034_(x, y, z);
            sword.m_6686_(xDir, yDir, zDir, 0.5f, 3.0f);
            this.entity.f_19853_.m_7967_((Entity)sword);
        }
    }
}

