/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.registry;

import com.klikli_dev.occultism.common.capability.DoubleJumpCapability;
import com.klikli_dev.occultism.common.capability.FamiliarSettingsCapability;
import com.klikli_dev.occultism.util.StaticUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class OccultismCapabilities {
    public static final ResourceLocation DOUBLE_JUMP_ID = StaticUtil.modLoc("double_jump");
    public static final ResourceLocation FAMILIAR_SETTINGS_ID = StaticUtil.modLoc("familiar_settings");
    public static Capability<DoubleJumpCapability> DOUBLE_JUMP = CapabilityManager.get((CapabilityToken)new CapabilityToken<DoubleJumpCapability>(){});
    public static Capability<FamiliarSettingsCapability> FAMILIAR_SETTINGS = CapabilityManager.get((CapabilityToken)new CapabilityToken<FamiliarSettingsCapability>(){});

    public static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(DoubleJumpCapability.class);
        event.register(FamiliarSettingsCapability.class);
    }

    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getEntity().getCapability(FAMILIAR_SETTINGS).ifPresent(newCap -> event.getOriginal().getCapability(FAMILIAR_SETTINGS).ifPresent(newCap::clone));
        }
    }

    public static void onJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            FamiliarSettingsCapability.syncFor(player);
        }
    }
}

