/*
 * Decompiled with CFR 0.152.
 */
package tfar.metalbarrels;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tfar.metalbarrels.datagen.ModDatagen;
import tfar.metalbarrels.init.ModBlockEntityTypes;
import tfar.metalbarrels.init.ModBlocks;
import tfar.metalbarrels.init.ModItems;
import tfar.metalbarrels.init.ModMenuTypes;
import tfar.metalbarrels.item.BarrelUpgradeItem;
import tfar.metalbarrels.network.PacketHandler;
import tfar.metalbarrels.screens.MetalBarrelScreen;

@Mod(value="metalbarrels")
public class MetalBarrels {
    public static final String MODID = "metalbarrels";
    public static final Logger logger = LogManager.getLogger();
    public static final CreativeModeTab tab = new CreativeModeTab("metalbarrels"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)ModBlocks.DIAMOND_BARREL);
        }
    };
    public static final String[] tiers = new String[]{"wood", "copper", "iron", "silver", "gold", "diamond", "obsidian", "netherite"};

    public MetalBarrels() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::doClientStuff);
        bus.addListener(this::commonSetup);
        bus.addListener(this::register);
        bus.addListener(ModDatagen::start);
    }

    public static <T> void superRegister(RegisterEvent e, Class<?> clazz, ResourceKey<? extends Registry<T>> resourceKey, Class filter) {
        for (Field field : clazz.getFields()) {
            try {
                Object o = field.get(null);
                if (!filter.isInstance(o)) continue;
                e.register(resourceKey, new ResourceLocation(MODID, field.getName().toLowerCase(Locale.ROOT)), () -> o);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    private void register(RegisterEvent event) {
        MetalBarrels.superRegister(event, ModBlocks.class, Registry.f_122901_, Block.class);
        MetalBarrels.superRegister(event, ModItems.class, Registry.f_122904_, Item.class);
        for (Map.Entry<String, BarrelUpgradeItem> entry : ModItems.upgrade_items.entrySet()) {
            event.register(Registry.f_122904_, new ResourceLocation(MODID, entry.getKey()), entry::getValue);
        }
        MetalBarrels.superRegister(event, ModBlockEntityTypes.class, Registry.f_122907_, BlockEntityType.class);
        MetalBarrels.superRegister(event, ModMenuTypes.class, Registry.f_122913_, MenuType.class);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(ModMenuTypes.COPPER, MetalBarrelScreen::copper);
        MenuScreens.m_96206_(ModMenuTypes.IRON, MetalBarrelScreen::iron);
        MenuScreens.m_96206_(ModMenuTypes.SILVER, MetalBarrelScreen::silver);
        MenuScreens.m_96206_(ModMenuTypes.GOLD, MetalBarrelScreen::gold);
        MenuScreens.m_96206_(ModMenuTypes.DIAMOND, MetalBarrelScreen::diamond);
        MenuScreens.m_96206_(ModMenuTypes.NETHERITE, MetalBarrelScreen::netherite);
    }
}

