/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProviders;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FoodProvider {
    public static final Codec<FoodProvider> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122827_.m_194605_().fieldOf("item").forGetter(f -> f.food), (App)Codec.INT.fieldOf("divider").forGetter(f -> f.divider)).apply((Applicative)instance, FoodProvider::create));
    protected final Item food;
    protected final int divider;
    public static final FoodProvider EMPTY = new FoodProvider(null, 1){

        @Override
        public Item getFood() {
            return Items.f_41852_;
        }
    };

    FoodProvider(Item food, int divider) {
        this.food = food;
        this.divider = divider;
    }

    public Item getFood() {
        return this.food;
    }

    public int getDivider() {
        return this.divider;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public boolean consume(Player player, Level world, @Nullable Consumer<ItemStack> nbtApplier) {
        ItemStack stack = this.food.m_7968_();
        if (nbtApplier != null) {
            nbtApplier.accept(stack);
        }
        FoodProperties foodProperties = PlatformHelper.getFoodProperties(this.food, stack, player);
        if (this.divider == 1) {
            this.food.m_5922_(stack.m_41777_(), world, (LivingEntity)player);
            if (foodProperties == null || stack.m_41720_().m_41472_()) {
                player.m_5496_(this.food.m_6023_(), 1.0f, 1.0f);
            }
            return true;
        }
        if (foodProperties != null && player.m_36391_(false)) {
            player.m_36324_().m_38707_(foodProperties.m_38744_() / this.divider, foodProperties.m_38745_() / (float)this.divider);
            player.m_5496_(this.food.m_6023_(), 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public static FoodProvider create(Item item, int divider) {
        return FoodProviders.CUSTOM_PROVIDERS.getOrDefault(item, new FoodProvider(item, divider));
    }
}

