/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts;

import com.illusivesoulworks.comforts.client.ComfortsClientEventsListener;
import com.illusivesoulworks.comforts.client.renderer.BaseComfortsBlockEntityRenderer;
import com.illusivesoulworks.comforts.client.renderer.HammockBlockEntityRenderer;
import com.illusivesoulworks.comforts.client.renderer.SleepingBagBlockEntityRenderer;
import com.illusivesoulworks.comforts.common.ComfortsRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ComfortsForgeClientMod {
    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(ComfortsForgeClientMod::clientSetup);
        eventBus.addListener(ComfortsForgeClientMod::entityRenderers);
        eventBus.addListener(ComfortsForgeClientMod::layerDefinitions);
        eventBus.addListener(ComfortsForgeClientMod::textureStitch);
    }

    private static void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ComfortsClientEventsListener());
    }

    private static void entityRenderers(EntityRenderersEvent.RegisterRenderers evt) {
        evt.registerBlockEntityRenderer(ComfortsRegistry.SLEEPING_BAG_BLOCK_ENTITY.get(), SleepingBagBlockEntityRenderer::new);
        evt.registerBlockEntityRenderer(ComfortsRegistry.HAMMOCK_BLOCK_ENTITY.get(), HammockBlockEntityRenderer::new);
    }

    private static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions evt) {
        evt.registerLayerDefinition(BaseComfortsBlockEntityRenderer.SLEEPING_BAG_HEAD, SleepingBagBlockEntityRenderer::createHeadLayer);
        evt.registerLayerDefinition(BaseComfortsBlockEntityRenderer.SLEEPING_BAG_FOOT, SleepingBagBlockEntityRenderer::createFootLayer);
        evt.registerLayerDefinition(BaseComfortsBlockEntityRenderer.HAMMOCK_HEAD, HammockBlockEntityRenderer::createHeadLayer);
        evt.registerLayerDefinition(BaseComfortsBlockEntityRenderer.HAMMOCK_FOOT, HammockBlockEntityRenderer::createFootLayer);
    }

    private static void textureStitch(TextureStitchEvent.Pre evt) {
        if (evt.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            for (DyeColor color : DyeColor.values()) {
                evt.addSprite(new ResourceLocation("comforts", "entity/hammock/" + color.m_41065_()));
                evt.addSprite(new ResourceLocation("comforts", "entity/sleeping_bag/" + color.m_41065_()));
            }
        }
    }
}

