/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape;

import gigaherz.packingtape.PackingTapeMod;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigValues {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int tapeRollUses;
    public static boolean consumesPaper;
    public static TagKey<BlockEntityType<?>> TE_WHITELIST;
    public static TagKey<BlockEntityType<?>> TE_BLACKLIST;

    public static void bake() {
        tapeRollUses = (Integer)ConfigValues.SERVER.tapeRollUses.get();
        consumesPaper = (Boolean)ConfigValues.SERVER.consumesPaper.get();
    }

    public static boolean isTileEntityBlocked(BlockEntity te) {
        BlockEntityType type = te.m_58903_();
        ResourceKey rk = (ResourceKey)Registry.f_122830_.m_7854_((Object)type).orElseThrow();
        Holder holder = Registry.f_122830_.m_206081_(rk);
        if (holder.m_203656_(TE_WHITELIST)) {
            return false;
        }
        if (te.m_6326_()) {
            return true;
        }
        return holder.m_203656_(TE_BLACKLIST);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (ServerConfig)specPair.getLeft();
        tapeRollUses = 8;
        consumesPaper = true;
        TE_WHITELIST = TagKey.m_203882_((ResourceKey)Registry.f_122907_, (ResourceLocation)PackingTapeMod.location("te_whitelist"));
        TE_BLACKLIST = TagKey.m_203882_((ResourceKey)Registry.f_122907_, (ResourceLocation)PackingTapeMod.location("te_blacklist"));
    }

    public static class ServerConfig {
        public ForgeConfigSpec.IntValue tapeRollUses;
        public ForgeConfigSpec.BooleanValue consumesPaper;

        ServerConfig(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.tapeRollUses = builder.comment("How many times the tape roll can be used before it breaks").translation("text.packingtape.config.tape_roll_uses").defineInRange("tape_roll_uses", 8, 0, 0x7FFFFFFE);
            this.consumesPaper = builder.comment("Whether the tape roll consumes paper when used").translation("text.packingtape.config.consume_paper").define("consume_paper", true);
            builder.pop();
        }
    }
}

