/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape.tape;

import gigaherz.packingtape.PackingTapeMod;
import gigaherz.packingtape.tape.PackagedBlockEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackagedBlock
extends Block
implements EntityBlock {
    private static Logger LOGGER = LogManager.getLogger();
    public static final BooleanProperty UNPACKING = BooleanProperty.m_61465_((String)"unpacking");

    public PackagedBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)UNPACKING, (Comparable)Boolean.valueOf(false)));
    }

    @Deprecated
    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return (Boolean)state.m_61143_((Property)UNPACKING);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PackagedBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UNPACKING});
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        if (Screen.m_96638_() || player.m_150110_().f_35937_ && Screen.m_96637_()) {
            return new ItemStack((ItemLike)this.m_5456_(), 1);
        }
        return new ItemStack((ItemLike)PackingTapeMod.TAPE.get(), 1);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PackagedBlockEntity) {
            PackagedBlockEntity packaged = (PackagedBlockEntity)te;
            if (!world.f_46443_ && player.m_7500_() && !packaged.isEmpty()) {
                ItemStack stack = packaged.getPackedStack();
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack);
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!placer.m_6144_() && placer instanceof Player) {
            Player player = (Player)placer;
            PackagedBlockEntity te = (PackagedBlockEntity)worldIn.m_7702_(pos);
            assert (te != null);
            te.setPreferredDirection(Direction.m_122364_((double)player.m_6080_()).m_122424_());
        }
        super.m_6402_(worldIn, pos, state, placer, stack);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof PackagedBlockEntity)) {
            return this.displayBlockMissingError(world, pos);
        }
        PackagedBlockEntity packagedBlock = (PackagedBlockEntity)te;
        BlockState newState = packagedBlock.getContainedBlockState();
        CompoundTag entityData = packagedBlock.getContainedTile();
        Direction preferred = packagedBlock.getPreferredDirection();
        if (newState == null || entityData == null) {
            return this.displayBlockMissingError(world, pos);
        }
        EnumProperty facing = null;
        for (Property prop : newState.m_61147_()) {
            if (!prop.m_61708_().equalsIgnoreCase("facing") && !prop.m_61708_().equalsIgnoreCase("rotation") || !(prop instanceof EnumProperty) || prop.m_61709_() != Direction.class) continue;
            facing = (EnumProperty)prop;
            break;
        }
        if (preferred != null && facing != null && facing.m_6908_().contains(preferred)) {
            newState = (BlockState)newState.m_61124_(facing, (Comparable)preferred);
        }
        if (facing != null && !player.m_6144_() && newState.m_60734_() instanceof ChestBlock && newState.m_61138_((Property)ChestBlock.f_51479_)) {
            Direction chestFacing = (Direction)newState.m_61143_(facing);
            Direction left = chestFacing.m_122427_();
            Direction right = chestFacing.m_122428_();
            BlockState leftState = world.m_8055_(pos.m_121945_(left));
            if (leftState.m_60734_() == newState.m_60734_() && leftState.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE && leftState.m_61143_((Property)ChestBlock.f_51478_) == chestFacing) {
                world.m_46597_(pos.m_121945_(left), (BlockState)leftState.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT));
                newState = (BlockState)newState.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT);
            } else {
                BlockState rightState = world.m_8055_(pos.m_121945_(right));
                if (rightState.m_60734_() == newState.m_60734_() && rightState.m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE && rightState.m_61143_((Property)ChestBlock.f_51478_) == chestFacing) {
                    world.m_46597_(pos.m_121945_(right), (BlockState)rightState.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.LEFT));
                    newState = (BlockState)newState.m_61124_((Property)ChestBlock.f_51479_, (Comparable)ChestType.RIGHT);
                }
            }
        }
        world.m_46747_(pos);
        world.m_46597_(pos, newState);
        PackagedBlock.setTileEntityNBT(world, player, pos, entityData);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult displayBlockMissingError(Level world, BlockPos pos) {
        LOGGER.error("The packaged block does not contain valid data");
        world.m_7106_((ParticleOptions)ParticleTypes.f_123792_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        return InteractionResult.CONSUME;
    }

    public static void setTileEntityNBT(Level level, @Nullable Player player, BlockPos pos, CompoundTag compoundtag) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return;
        }
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity != null) {
            if (!(level.f_46443_ || !blockentity.m_6326_() || player != null && player.m_36337_())) {
                return;
            }
            CompoundTag current = blockentity.m_187482_();
            CompoundTag original = current.m_6426_();
            current.m_128391_(compoundtag);
            if (!current.equals((Object)original)) {
                blockentity.m_142466_(current);
                blockentity.m_6596_();
            }
        }
    }

    private static Component makeError(String detail) {
        return Component.m_237110_((String)"text.packingtape.packaged.missing_data", (Object[])new Object[]{Component.m_237115_((String)detail)});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag advanced) {
        super.m_5871_(stack, worldIn, tooltip, advanced);
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            tooltip.add(PackagedBlock.makeError("text.packingtape.packaged.no_nbt"));
            return;
        }
        CompoundTag info = (CompoundTag)tag.m_128423_("BlockEntityTag");
        if (info == null) {
            tooltip.add(PackagedBlock.makeError("text.packingtape.packaged.no_tag"));
            return;
        }
        if (!info.m_128441_("Block") || !info.m_128441_("BlockEntity")) {
            tooltip.add(PackagedBlock.makeError("text.packingtape.packaged.no_block"));
            return;
        }
        String blockName = info.m_128469_("Block").m_128461_("Name");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockName));
        if (block == null || block == Blocks.f_50016_) {
            tooltip.add((Component)Component.m_237115_((String)"text.packingtape.packaged.unknown_block"));
            tooltip.add((Component)Component.m_237113_((String)("  " + blockName)));
            return;
        }
        Item item = block.m_5456_();
        if (item == Items.f_41852_ && (item = (Item)ForgeRegistries.ITEMS.getValue(ForgeRegistries.BLOCKS.getKey((Object)block))) == Items.f_41852_) {
            tooltip.add((Component)Component.m_237115_((String)"text.packingtape.packaged.no_item"));
            tooltip.add((Component)Component.m_237113_((String)("  " + blockName)));
            return;
        }
        ItemStack stack1 = new ItemStack((ItemLike)item, 1);
        tooltip.add((Component)Component.m_237110_((String)"text.packingtape.packaged.contains", (Object[])new Object[]{stack1.m_41786_()}));
    }
}

