/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.packingtape.tape;

import gigaherz.packingtape.PackingTapeMod;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PackagedBlockEntity
extends BlockEntity {
    private static Logger LOGGER = LogManager.getLogger();
    private BlockState containedBlockState;
    private CompoundTag containedTile;
    private Direction preferredDirection;

    public PackagedBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public PackagedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackingTapeMod.PACKAGED_BLOCK_ENTITY.get(), pos, state);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.containedBlockState != null) {
            CompoundTag blockData = NbtUtils.m_129202_((BlockState)this.containedBlockState);
            compound.m_128365_("Block", (Tag)blockData);
            compound.m_128365_("BlockEntity", (Tag)this.containedTile.m_6426_());
            if (this.preferredDirection != null) {
                compound.m_128405_("PreferredDirection", this.preferredDirection.ordinal());
            }
        }
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("containedBlock", 8)) {
            CompoundTag tempTag = new CompoundTag();
            tempTag.m_128359_("Name", compound.m_128461_("containedBlock"));
            tempTag.m_128365_("Properties", compound.m_128423_("containedBlockState"));
            this.containedBlockState = NbtUtils.m_129241_((CompoundTag)tempTag);
            this.containedTile = compound.m_128469_("containedTile").m_6426_();
            if (compound.m_128441_("preferredDirection")) {
                this.preferredDirection = Direction.values()[compound.m_128451_("preferredDirection")];
            }
        } else {
            CompoundTag blockTag = compound.m_128469_("Block");
            this.containedBlockState = NbtUtils.m_129241_((CompoundTag)blockTag);
            this.containedTile = compound.m_128469_("BlockEntity").m_6426_();
            if (compound.m_128441_("PreferredDirection")) {
                this.preferredDirection = Direction.m_122402_((String)compound.m_128461_("PreferredDirection"));
            }
        }
    }

    public BlockState getContainedBlockState() {
        return this.containedBlockState;
    }

    public CompoundTag getContainedTile() {
        return this.containedTile;
    }

    public void setContents(BlockState state, CompoundTag tag) {
        this.containedBlockState = state;
        this.containedTile = tag;
    }

    @Nullable
    public Direction getPreferredDirection() {
        return this.preferredDirection;
    }

    public void setPreferredDirection(Direction preferredDirection) {
        this.preferredDirection = preferredDirection;
    }

    public ItemStack getPackedStack() {
        ItemStack stack = new ItemStack((ItemLike)PackingTapeMod.PACKAGED_BLOCK.get());
        CompoundTag tileEntityData = this.m_187482_();
        CompoundTag stackTag = new CompoundTag();
        stackTag.m_128365_("BlockEntityTag", (Tag)tileEntityData);
        stack.m_41751_(stackTag);
        LOGGER.debug(String.format("Created Packed stack with %s", this.containedBlockState.toString()));
        return stack;
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public boolean isEmpty() {
        return this.containedBlockState == null || this.containedBlockState.m_60795_();
    }
}

