/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.ars_nouveau.geckolib3.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import software.bernie.ars_nouveau.geckolib3.GeckoLib;
import software.bernie.ars_nouveau.geckolib3.core.molang.MolangParser;
import software.bernie.ars_nouveau.geckolib3.file.AnimationFile;
import software.bernie.ars_nouveau.geckolib3.file.AnimationFileLoader;
import software.bernie.ars_nouveau.geckolib3.file.GeoModelLoader;
import software.bernie.ars_nouveau.geckolib3.geo.render.built.GeoModel;

public class GeckoLibCache {
    private static GeckoLibCache INSTANCE;
    private static final Set<String> excludedNamespaces;
    private final AnimationFileLoader animationLoader;
    private final GeoModelLoader modelLoader;
    public final MolangParser parser = new MolangParser();
    private Map<ResourceLocation, AnimationFile> animations = Collections.emptyMap();
    private Map<ResourceLocation, GeoModel> geoModels = Collections.emptyMap();

    public Map<ResourceLocation, AnimationFile> getAnimations() {
        if (!GeckoLib.hasInitialized) {
            throw new RuntimeException("GeckoLib was never initialized! Please read the documentation!");
        }
        return this.animations;
    }

    public Map<ResourceLocation, GeoModel> getGeoModels() {
        if (!GeckoLib.hasInitialized) {
            throw new RuntimeException("GeckoLib was never initialized! Please read the documentation!");
        }
        return this.geoModels;
    }

    protected GeckoLibCache() {
        this.animationLoader = new AnimationFileLoader();
        this.modelLoader = new GeoModelLoader();
    }

    public static GeckoLibCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GeckoLibCache();
            return INSTANCE;
        }
        return INSTANCE;
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap geoModels = new Object2ObjectOpenHashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "animations", animation -> this.animationLoader.loadAllAnimations(this.parser, (ResourceLocation)animation, resourceManager), ((Map)animations)::put);
        completableFutureArray[1] = GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "geo", resource -> this.modelLoader.loadModel(resourceManager, (ResourceLocation)resource), ((Map)geoModels)::put);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$2((Map)animations, (Map)geoModels, arg_0), gameExecutor);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, ResourceManager resourceManager, String type, Function<ResourceLocation, T> loader, BiConsumer<ResourceLocation, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.m_214159_(type, fileName -> fileName.toString().endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (ResourceLocation resource : resources.keySet()) {
                CompletableFuture<Object> existing = tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
                if (existing == null) continue;
                System.err.println("Duplicate resource for " + resource);
                existing.cancel(false);
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (excludedNamespaces.contains(((ResourceLocation)entry.getKey()).m_135827_().toLowerCase(Locale.ROOT))) continue;
                map.accept((ResourceLocation)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }

    private /* synthetic */ void lambda$reload$2(Map animations, Map geoModels, Void empty) {
        this.animations = animations;
        this.geoModels = geoModels;
    }

    static {
        excludedNamespaces = ObjectOpenHashSet.of((Object)"moreplayermodels", (Object)"customnpcs", (Object)"gunsrpg");
    }
}

