/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.common.util.ExpandNewLineTextAcceptor;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class StringUtil {
    private StringUtil() {
    }

    public static Component stripStyling(Component textComponent) {
        MutableComponent text = textComponent.m_6879_();
        for (Component sibling : textComponent.m_7360_()) {
            text.m_7220_(StringUtil.stripStyling(sibling));
        }
        return text;
    }

    public static String removeChatFormatting(String string) {
        String result = ChatFormatting.m_126649_((String)string);
        return result == null ? "" : result;
    }

    public static Component truncateStringToWidth(Component text, int width, Font fontRenderer) {
        int ellipsisWidth = fontRenderer.m_92895_("...");
        FormattedText truncatedText = fontRenderer.m_92854_((FormattedText)text, width - ellipsisWidth);
        String truncatedTextString = truncatedText.getString();
        return Component.m_237113_((String)(truncatedTextString + "..."));
    }

    public static List<FormattedText> splitLines(List<FormattedText> lines, int width) {
        if (width <= 0) {
            return List.copyOf(lines);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        StringSplitter splitter = font.m_92865_();
        return lines.stream().flatMap(text -> splitter.m_92414_(text, width, Style.f_131099_).stream()).toList();
    }

    public static List<FormattedText> expandNewlines(Component ... descriptionComponents) {
        ArrayList<FormattedText> descriptionLinesExpanded = new ArrayList<FormattedText>();
        for (Component descriptionLine : descriptionComponents) {
            ExpandNewLineTextAcceptor newLineTextAcceptor = new ExpandNewLineTextAcceptor();
            descriptionLine.m_7451_((FormattedText.StyledContentConsumer)newLineTextAcceptor, Style.f_131099_);
            newLineTextAcceptor.addLinesTo(descriptionLinesExpanded);
        }
        return descriptionLinesExpanded;
    }

    public static String intsToString(Collection<Integer> indexes) {
        return indexes.stream().sorted().map(i -> Integer.toString(i)).collect(Collectors.joining(", "));
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, String string, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, string);
        Screen.m_93236_((PoseStack)poseStack, (Font)font, (String)string, (int)textArea.getX(), (int)textArea.getY(), (int)-1);
    }

    public static void drawCenteredStringWithShadow(PoseStack poseStack, Font font, Component text, ImmutableRect2i area) {
        ImmutableRect2i textArea = MathUtil.centerTextArea(area, font, (FormattedText)text);
        Screen.m_93243_((PoseStack)poseStack, (Font)font, (Component)text, (int)textArea.getX(), (int)textArea.getY(), (int)-1);
    }
}

