/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.recipes;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Optional;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Internal;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.gui.input.IUserInputHandler;
import mezz.jei.gui.input.UserInput;
import mezz.jei.gui.input.handlers.CombinedInputHandler;
import mezz.jei.gui.recipes.RecipeTransferButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.Nullable;

public record RecipeLayoutWithButtons<R>(IRecipeLayoutDrawable<R> recipeLayout, RecipeTransferButton transferButton) {
    public int totalWidth() {
        Rect2i area = this.recipeLayout.getRect();
        Rect2i areaWithBorder = this.recipeLayout.getRectWithBorder();
        int leftBorderWidth = area.m_110085_() - areaWithBorder.m_110085_();
        int rightAreaWidth = areaWithBorder.m_110090_() - leftBorderWidth;
        if (this.transferButton.isVisible()) {
            Rect2i buttonArea = this.recipeLayout.getRecipeTransferButtonArea();
            int buttonRight = buttonArea.m_110085_() + buttonArea.m_110090_();
            rightAreaWidth = Math.max(buttonRight, rightAreaWidth);
        }
        return leftBorderWidth + rightAreaWidth;
    }

    public IUserInputHandler createUserInputHandler() {
        return new CombinedInputHandler("RecipeLayoutWithButtons", this.transferButton.createInputHandler(), new RecipeLayoutUserInputHandler<R>(this.recipeLayout));
    }

    public void tick(@Nullable AbstractContainerMenu parentContainer, @Nullable Player player) {
        this.recipeLayout.tick();
        this.transferButton.update(parentContainer, player);
    }

    private record RecipeLayoutUserInputHandler<R>(IRecipeLayoutDrawable<R> recipeLayout) implements IUserInputHandler
    {
        @Override
        public Optional<IUserInputHandler> handleUserInput(Screen screen, UserInput input, IInternalKeyMappings keyBindings) {
            double mouseY;
            double mouseX = input.getMouseX();
            if (this.recipeLayout.isMouseOver(mouseX, mouseY = input.getMouseY())) {
                InputConstants.Key key = input.getKey();
                boolean simulate = input.isSimulate();
                if (this.recipeLayout.getInputHandler().handleInput(mouseX, mouseY, input)) {
                    return Optional.of(this);
                }
                IInternalKeyMappings keyMappings = Internal.getKeyMappings();
                if (keyMappings.getCopyRecipeId().isActiveAndMatches(key) && this.handleCopyRecipeId(this.recipeLayout, simulate)) {
                    return Optional.of(this);
                }
            }
            return Optional.empty();
        }

        private boolean handleCopyRecipeId(IRecipeLayoutDrawable<R> recipeLayout, boolean simulate) {
            R recipe;
            if (simulate) {
                return true;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            IRecipeCategory<R> recipeCategory = recipeLayout.getRecipeCategory();
            ResourceLocation registryName = recipeCategory.getRegistryName(recipe = recipeLayout.getRecipe());
            if (registryName == null) {
                MutableComponent message = Component.m_237115_((String)"jei.message.copy.recipe.id.failure");
                if (player != null) {
                    player.m_5661_((Component)message, false);
                }
                return false;
            }
            String recipeId = registryName.toString();
            minecraft.f_91068_.m_90911_(recipeId);
            MutableComponent message = Component.m_237110_((String)"jei.message.copy.recipe.id.success", (Object[])new Object[]{Component.m_237113_((String)recipeId)});
            if (player != null) {
                player.m_5661_((Component)message, false);
            }
            return true;
        }

        @Override
        public Optional<IUserInputHandler> handleMouseScrolled(double mouseX, double mouseY, double scrollDeltaY) {
            if (this.recipeLayout.isMouseOver(mouseX, mouseY) && this.recipeLayout.getInputHandler().handleMouseScrolled(mouseX, mouseY, scrollDeltaY)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }
    }
}

