/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.api.modules;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.resources.IInMemoryResourcePack;

public interface IModule
extends Comparable<IModule> {
    public String getName();

    default public boolean isPassive() {
        return false;
    }

    default public void defineModuleConfigPre(IModuleData moduleData, IDynamicSpecConfig config) {
    }

    default public void defineMaterialConfigPre(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
    }

    default public Multimap<Integer, String> getModuleDependencies() {
        return ImmutableSetMultimap.of();
    }

    default public List<IFormRequest> getFormRequests() {
        return List.of();
    }

    default public Set<MaterialType> getMaterialTypes() {
        return Set.of();
    }

    default public Set<String> getDefaultMaterialBlacklist() {
        return Set.of();
    }

    default public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
    }

    default public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
    }

    default public void onMaterialComputeComplete(IModuleData moduleData) {
    }

    default public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
    }

    default public void onClientSetup(IModuleData moduleData, FMLClientSetupEvent event) {
    }

    default public void onInterModEnqueue(IModuleData moduleData, InterModEnqueueEvent event) {
    }

    default public void onCreateResourcePack(IModuleData moduleData, IInMemoryResourcePack resourcePack) {
    }

    default public void onCreateDataPack(IModuleData moduleData, IInMemoryResourcePack resourcePack) {
    }

    @Override
    default public int compareTo(IModule other) {
        return this.getName().compareTo(other.getName());
    }
}

