/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.assemblylinemachines.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import me.haydenb.assemblylinemachines.registry.utils.CountIngredient;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.assemblylinemachines.AssemblyLineMachinesHelper;
import thelm.jaopca.utils.MiscHelper;

public class PneumaticRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object mold;
    public final Object output;
    public final int outputCount;
    public final int time;

    public PneumaticRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object mold, Object output, int outputCount, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.mold = mold;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        CountIngredient ing = AssemblyLineMachinesHelper.INSTANCE.getCountIngredient(this.input, this.inputCount);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        Item moldItem = MiscHelper.INSTANCE.getItemStack(this.mold, 1).m_41720_();
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "assemblylinemachines:pneumatic");
        json.add("input", (JsonElement)ing.toJson());
        json.addProperty("moldItem", ForgeRegistries.ITEMS.getKey((Object)moldItem).toString());
        json.add("output", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("time", (Number)this.time);
        return json;
    }
}

