/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.ingredients.CompoundIngredientObject;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.create.CreateHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"create"})
public class CreateModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "iron", "zinc"));
    private Map<IMaterial, IDynamicSpecConfig> configs;
    private final IForm crushedForm = ApiImpl.INSTANCE.newForm(this, "create_crushed_ores", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT, MaterialType.INGOT_LEGACY).setSecondaryName("create:crushed_raw_materials").setDefaultMaterialBlacklist(BLACKLIST);

    @Override
    public String getName() {
        return "create";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"nuggets");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return List.of(this.crushedForm.toRequest());
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        String[] toRegister;
        ApiImpl api = ApiImpl.INSTANCE;
        CreateHelper helper = CreateHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        ResourceLocation deepslateOreLocation = new ResourceLocation("forge:ores_in_ground/deepslate");
        ResourceLocation netherrackOreLocation = new ResourceLocation("forge:ores_in_ground/netherrack");
        ResourceLocation endstoneOreLocation = new ResourceLocation("forge:ores_in_ground/end_stone");
        Item xpNugget = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create:experience_nugget"));
        Item cobbledDeepslate = Items.f_151035_;
        Item netherrack = Items.f_42048_;
        Item endstone = Items.f_42102_;
        for (IMaterial material : this.crushedForm.getMaterials()) {
            IItemInfo crushedInfo = itemFormType.getMaterialFormInfo(this.crushedForm, material);
            ResourceLocation crushedLocation = miscHelper.getTagLocation("create:crushed_raw_materials", material.getName());
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation nuggetLocation = miscHelper.getTagLocation("nuggets", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            IDynamicSpecConfig config = this.configs.get(material);
            String configByproduct = config.getDefinedString("create.byproduct", "minecraft:cobblestone", s -> ForgeRegistries.ITEMS.containsKey(new ResourceLocation(s)), "The default byproduct material to output in Create's crushing.");
            Item byproduct = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(configByproduct));
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "create.default_ore_to_crushed." + material.getName()), CompoundIngredientObject.difference(oreLocation, deepslateOreLocation, netherrackOreLocation, endstoneOreLocation), 250, crushedInfo, 1, crushedInfo, 1, Float.valueOf(0.75f), xpNugget, 1, Float.valueOf(0.75f), byproduct, 1, Float.valueOf(0.125f));
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "create.deepslate_ore_to_crushed." + material.getName()), CompoundIngredientObject.intersection(oreLocation, deepslateOreLocation), 350, crushedInfo, 2, crushedInfo, 1, Float.valueOf(0.25f), xpNugget, 1, Float.valueOf(0.75f), cobbledDeepslate, 1, Float.valueOf(0.125f));
            helper.registerCrushingRecipe(new ResourceLocation("jaopca", "create.netherrack_ore_to_crushed." + material.getName()), CompoundIngredientObject.intersection(oreLocation, netherrackOreLocation), 350, crushedInfo, 1, crushedInfo, 1, Float.valueOf(0.75f), xpNugget, 1, Float.valueOf(0.75f), netherrack, 1, Float.valueOf(0.125f));
            if (itemTags.contains(endstoneOreLocation)) {
                helper.registerCrushingRecipe(new ResourceLocation("jaopca", "create.end_stone_ore_to_crushed." + material.getName()), CompoundIngredientObject.intersection(oreLocation, endstoneOreLocation), 350, crushedInfo, 1, crushedInfo, 1, Float.valueOf(0.75f), xpNugget, 1, Float.valueOf(0.75f), endstone, 1, Float.valueOf(0.125f));
            }
            if (material.getType() == MaterialType.INGOT) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
                ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", material.getName(), "_");
                helper.registerCrushingRecipe(new ResourceLocation("jaopca", "create.raw_material_to_crushed." + material.getName()), rawMaterialLocation, 400, crushedInfo, 1, xpNugget, 1, Float.valueOf(0.75f));
                if (itemTags.contains(rawStorageBlockLocation)) {
                    helper.registerCrushingRecipe(new ResourceLocation("jaopca", "create.raw_storage_block_to_crushed." + material.getName()), rawStorageBlockLocation, 400, crushedInfo, 9, xpNugget, 9, Float.valueOf(0.75f));
                }
            }
            ((JAOPCAApi)api).registerSmeltingRecipe(new ResourceLocation("jaopca", "create.crushed_to_material_smelting." + material.getName()), crushedLocation, materialLocation, 1, 0.1f, 200);
            ((JAOPCAApi)api).registerBlastingRecipe(new ResourceLocation("jaopca", "create.crushed_to_material_blasting." + material.getName()), crushedLocation, materialLocation, 1, 0.1f, 100);
            helper.registerSplashingRecipe(new ResourceLocation("jaopca", "create.crushed_to_nugget." + material.getName()), crushedLocation, nuggetLocation, 9);
        }
        for (String material : toRegister = new String[]{"aluminum", "copper", "gold", "iron", "lead", "nickel", "osmium", "platinum", "quicksilver", "silver", "tin", "uranium", "zinc"}) {
            ((JAOPCAApi)api).registerItemTag(miscHelper.getTagLocation("create:crushed_raw_materials", material), new ResourceLocation("create", "crushed_raw_" + material));
        }
    }

    static {
        if (ModList.get().isLoaded("galosphere")) {
            Collections.addAll(BLACKLIST, "silver");
        }
        if (ModList.get().isLoaded("ic2")) {
            Collections.addAll(BLACKLIST, "aluminium", "aluminum", "silver", "tin", "uranium");
        }
        if (ModList.get().isLoaded("iceandfire")) {
            Collections.addAll(BLACKLIST, "silver");
        }
        if (ModList.get().isLoaded("immersiveengineering")) {
            Collections.addAll(BLACKLIST, "aluminium", "aluminum", "lead", "nickel", "silver", "uranium");
        }
        if (ModList.get().isLoaded("mekanism")) {
            Collections.addAll(BLACKLIST, "lead", "osmium", "tin", "uranium");
        }
        if (ModList.get().isLoaded("oreganized")) {
            Collections.addAll(BLACKLIST, "lead");
        }
        if (ModList.get().isLoaded("thermal")) {
            Collections.addAll(BLACKLIST, "lead", "nickel", "silver", "tin");
        }
    }
}

