/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.factorium.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class PulverizerRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final float outputChance;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondOutputChance;
    public final Object thirdOutput;
    public final int thirdOutputCount;
    public final float thirdOutputChance;

    public PulverizerRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, float outputChance) {
        this(key, input, output, outputCount, outputChance, ItemStack.f_41583_, 0, 0.0f, ItemStack.f_41583_, 0, 0.0f);
    }

    public PulverizerRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, float outputChance, Object secondOutput, int secondOutputCount, float secondOutputChance, Object thirdOutput, int thirdOutputCount, float thirdOutputChance) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.outputChance = outputChance;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondOutputChance = secondOutputChance;
        this.thirdOutput = thirdOutput;
        this.thirdOutputCount = thirdOutputCount;
        this.thirdOutputChance = thirdOutputChance;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        ItemStack stack1 = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack1.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        ItemStack stack2 = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        ItemStack stack3 = MiscHelper.INSTANCE.getItemStack(this.thirdOutput, this.thirdOutputCount);
        JsonObject json = new JsonObject();
        json.addProperty("type", "factorium:pulverizer");
        json.add("input", ing.m_43942_());
        JsonObject outputJson1 = MiscHelper.INSTANCE.serializeItemStack(stack1);
        outputJson1.addProperty("chance", (Number)Float.valueOf(this.outputChance));
        json.add("output", (JsonElement)outputJson1);
        if (!stack2.m_41619_()) {
            JsonObject outputJson2 = MiscHelper.INSTANCE.serializeItemStack(stack2);
            outputJson2.addProperty("chance", (Number)Float.valueOf(this.secondOutputChance));
            json.add("secondary", (JsonElement)outputJson2);
        }
        if (!stack3.m_41619_()) {
            JsonObject outputJson3 = MiscHelper.INSTANCE.serializeItemStack(stack3);
            outputJson3.addProperty("chance", (Number)Float.valueOf(this.thirdOutputChance));
            json.add("bonus", (JsonElement)outputJson3);
        }
        return json;
    }
}

