/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.kubejs.utils;

import java.util.List;
import java.util.TreeMap;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.compat.kubejs.utils.Form;
import thelm.jaopca.compat.kubejs.utils.Material;
import thelm.jaopca.forms.FormHandler;
import thelm.jaopca.modules.ModuleHandler;

public class Module {
    private static final TreeMap<IModule, Module> MODULE_WRAPPERS = new TreeMap();
    private final IModule module;
    private final IModuleData moduleData;

    public static Module getModuleWrapper(IModule form) {
        return MODULE_WRAPPERS.computeIfAbsent(form, Module::new);
    }

    private Module(IModule module) {
        this.module = module;
        this.moduleData = ModuleHandler.getModuleData(module);
    }

    public IModule getInternal() {
        return this.module;
    }

    public String getName() {
        return this.module.getName();
    }

    public List<String> getMaterialTypes() {
        return this.module.getMaterialTypes().stream().map(MaterialType::getName).toList();
    }

    public List<Material> getMaterials() {
        return this.moduleData.getMaterials().stream().map(Material::getMaterialWrapper).toList();
    }

    public boolean containsMaterial(Material material) {
        return this.moduleData.getMaterials().contains(material.getInternal());
    }

    public List<Form> getForms() {
        return FormHandler.getForms().stream().filter(f -> f.getModule() == this.module).map(Form::getFormWrapper).toList();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Module) {
            Module other = (Module)obj;
            return this.module == other.module;
        }
        return false;
    }

    public int hashCode() {
        return this.module.hashCode() + 5;
    }
}

