/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import mekanism.api.MekanismAPI;
import net.minecraft.resources.ResourceLocation;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.data.DataCollector;
import thelm.jaopca.utils.ApiImpl;

public class MekanismDataInjector {
    public static final Set<ResourceLocation> GAS_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> INFUSE_TYPE_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> PIGMENT_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> SLURRY_TAG_BLACKLIST = new TreeSet<ResourceLocation>();

    private MekanismDataInjector() {
    }

    public static boolean registerGasTag(ResourceLocation location, ResourceLocation gasLocation) {
        if (GAS_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.gasRegistryName(), location, gasLocation);
    }

    public static boolean registerInfuseTypeTag(ResourceLocation location, ResourceLocation infuseTypeLocation) {
        if (INFUSE_TYPE_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.infuseTypeRegistryName(), location, infuseTypeLocation);
    }

    public static boolean registerPigmentTag(ResourceLocation location, ResourceLocation pigmentLocation) {
        if (PIGMENT_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.pigmentRegistryName(), location, pigmentLocation);
    }

    public static boolean registerSlurryTag(ResourceLocation location, ResourceLocation slurryLocation) {
        if (SLURRY_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        return ApiImpl.INSTANCE.registerTag(MekanismAPI.slurryRegistryName(), location, slurryLocation);
    }

    static void setupConfig(IDynamicSpecConfig config) {
        config.setComment("gasTags", "Configurations related to gas tags.");
        GAS_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("gasTags.blacklist", new ArrayList<String>(), "List of gas tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("gases").addAll(Lists.transform(config.getDefinedStringList("gasTags.customDefined", new ArrayList<String>(), "List of gas tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("infuseTypeTags", "Configurations related to infuse type tags.");
        INFUSE_TYPE_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("infuseTypes").addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("pigmentTags", "Configurations related to pigment tags.");
        PIGMENT_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("pigmentTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("pigments").addAll(Lists.transform(config.getDefinedStringList("pigmentTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("slurryTags", "Configurations related to slurry tags.");
        SLURRY_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("slurryTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("slurries").addAll(Lists.transform(config.getDefinedStringList("slurryTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
    }
}

