/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.nuclearcraft.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class MelterRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputAmount;
    public final double radiation;
    public final double time;
    public final double power;

    public MelterRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputAmount, double radiation, double time, double power) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputAmount = outputAmount;
        this.radiation = radiation;
        this.time = time;
        this.power = power;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.input));
        }
        FluidStack stack = MiscHelper.INSTANCE.getFluidStack(this.output, this.outputAmount);
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + String.valueOf(this.key) + ": " + String.valueOf(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "nuclearcraft:melter");
        JsonArray inputJson = new JsonArray();
        JsonObject ingJson = MiscHelper.INSTANCE.wrapIngredient(ing).m_43942_().getAsJsonObject();
        ingJson.addProperty("count", (Number)this.inputCount);
        inputJson.add((JsonElement)ingJson);
        json.add("input", (JsonElement)inputJson);
        JsonArray outputJson = new JsonArray();
        outputJson.add((JsonElement)MiscHelper.INSTANCE.serializeFluidStack(stack));
        json.add("outputFluids", (JsonElement)outputJson);
        json.addProperty("radiation", (Number)this.radiation);
        json.addProperty("timeModifier", (Number)this.time);
        json.addProperty("powerModifier", (Number)this.power);
        return json;
    }
}

