/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongRBTreeMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.ToLongFunction;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.custom.CustomModule;
import thelm.jaopca.materials.Material;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.utils.JsonHelper;

public class MaterialLongFunctionDeserializer
implements JsonDeserializer<ToLongFunction<IMaterial>> {
    public static final MaterialLongFunctionDeserializer INSTANCE = new MaterialLongFunctionDeserializer();

    private MaterialLongFunctionDeserializer() {
    }

    public ToLongFunction<IMaterial> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = JsonHelper.INSTANCE;
        JsonObject json = helper.getJsonObject(jsonElement, "object");
        long defaultValue = helper.getLong(json, "default");
        Object2LongRBTreeMap map = new Object2LongRBTreeMap();
        map.defaultReturnValue(defaultValue);
        if (json.has("materialTypes")) {
            JsonObject materialTypesJson = helper.getJsonObject(json, "materialTypes");
            for (Map.Entry entry : materialTypesJson.entrySet()) {
                long materialTypeValue = helper.getLong((JsonElement)entry.getValue(), "element");
                switch ((String)entry.getKey()) {
                    case "ingot": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isIngot()).forEach(arg_0 -> MaterialLongFunctionDeserializer.lambda$deserialize$1((Object2LongMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "gem": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isGem()).forEach(arg_0 -> MaterialLongFunctionDeserializer.lambda$deserialize$3((Object2LongMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "crystal": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isCrystal()).forEach(arg_0 -> MaterialLongFunctionDeserializer.lambda$deserialize$5((Object2LongMap)map, materialTypeValue, arg_0));
                        break;
                    }
                    case "dust": {
                        MaterialHandler.getMaterials().stream().filter(m -> m.getType().isDust()).forEach(arg_0 -> MaterialLongFunctionDeserializer.lambda$deserialize$7((Object2LongMap)map, materialTypeValue, arg_0));
                    }
                }
            }
        }
        if (json.has("materials")) {
            JsonObject materialsJson = json.get("materials").getAsJsonObject();
            for (Map.Entry entry : materialsJson.entrySet()) {
                if (!MaterialHandler.containsMaterial((String)entry.getKey())) continue;
                map.put((Object)MaterialHandler.getMaterial((String)entry.getKey()), helper.getLong((JsonElement)entry.getValue(), "element"));
            }
        }
        if (json.has("config") && helper.getBoolean(json, "config")) {
            String path = helper.getString(json, "path");
            String comment = json.has("comment") ? helper.getString(json, "comment") : "";
            CustomModule.instance.addCustomConfigDefiner((arg_0, arg_1) -> MaterialLongFunctionDeserializer.lambda$deserialize$8((Object2LongMap)map, path, comment, arg_0, arg_1));
        }
        return map;
    }

    private static /* synthetic */ void lambda$deserialize$8(Object2LongMap map, String path, String comment, IMaterial material, IDynamicSpecConfig config) {
        map.put((Object)material, config.getDefinedLong(path, map.getLong((Object)material), comment));
    }

    private static /* synthetic */ void lambda$deserialize$7(Object2LongMap map, long materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$5(Object2LongMap map, long materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$3(Object2LongMap map, long materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }

    private static /* synthetic */ void lambda$deserialize$1(Object2LongMap map, long materialTypeValue, Material m) {
        map.put((Object)m, materialTypeValue);
    }
}

