/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidType;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IMaterialFormFluid;
import thelm.jaopca.api.fluids.PlaceableFluid;
import thelm.jaopca.api.fluids.PlaceableFluidBlock;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.functions.MemoizingSuppliers;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.FluidFormType;

public class JAOPCAFluid
extends PlaceableFluid
implements IMaterialFormFluid {
    private final IForm form;
    private final IMaterial material;
    protected final IFluidFormSettings settings;
    protected IntSupplier tickRate;
    protected DoubleSupplier explosionResistance;
    protected IntSupplier levelDecreasePerBlock;

    public JAOPCAFluid(IForm form, IMaterial material, IFluidFormSettings settings) {
        super(settings.getMaxLevelFunction().applyAsInt(material));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.tickRate = MemoizingSuppliers.of(settings.getTickRateFunction(), () -> material);
        this.explosionResistance = MemoizingSuppliers.of(settings.getExplosionResistanceFunction(), () -> material);
        this.levelDecreasePerBlock = MemoizingSuppliers.of(settings.getLevelDecreasePerBlockFunction(), () -> material);
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public int m_6718_(LevelReader world) {
        return this.tickRate.getAsInt();
    }

    protected float m_6752_() {
        return (float)this.explosionResistance.getAsDouble();
    }

    @Override
    protected int getDropOff(LevelReader world) {
        return this.levelDecreasePerBlock.getAsInt();
    }

    @Override
    public FluidState getSourceState() {
        return (FluidState)this.m_76145_().m_61124_((Property)this.levelProperty, (Comparable)Integer.valueOf(this.maxLevel));
    }

    public FluidType getFluidType() {
        return FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getFluidType();
    }

    @Override
    protected PlaceableFluidBlock getFluidBlock() {
        return (PlaceableFluidBlock)FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getMaterialFormFluidBlock().toBlock();
    }

    public Item m_6859_() {
        return FluidFormType.INSTANCE.getMaterialFormInfo(this.form, this.material).getBucketItem();
    }
}

