/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;

public class PiglinSpecificSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.f_26333_, MemoryModuleType.f_26343_, MemoryModuleType.f_26344_, MemoryModuleType.f_26351_, MemoryModuleType.f_26345_, MemoryModuleType.f_26354_, MemoryModuleType.f_26347_, MemoryModuleType.f_26352_, MemoryModuleType.f_26353_, MemoryModuleType.f_26356_, MemoryModuleType.f_148204_, MemoryModuleType.f_26346_});

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.PIGLIN_SPECIFIC.get();
    }

    @Override
    protected void m_5578_(ServerLevel level, E entity) {
        Brain brain = entity.m_6274_();
        ObjectArrayList adultPiglins = new ObjectArrayList();
        BrainUtils.withMemory(brain, MemoryModuleType.f_148205_, entities -> {
            Mob nemesis = null;
            Hoglin nearestHuntableHoglin = null;
            Hoglin nearestBabyHoglin = null;
            LivingEntity nearestZombified = null;
            Player nearestPlayerWithoutGold = null;
            Player nearestPlayerWithWantedItem = null;
            ObjectArrayList visibleAdultPiglins = new ObjectArrayList();
            int adultHoglinCount = 0;
            for (LivingEntity target : entities.m_186123_(obj -> true)) {
                if (target instanceof Hoglin) {
                    Hoglin hoglin = (Hoglin)target;
                    if (hoglin.m_6162_() && nearestBabyHoglin == null) {
                        nearestBabyHoglin = hoglin;
                        continue;
                    }
                    if (!hoglin.m_34552_()) continue;
                    ++adultHoglinCount;
                    if (nearestHuntableHoglin != null || !hoglin.m_34555_()) continue;
                    nearestHuntableHoglin = hoglin;
                    continue;
                }
                if (target instanceof PiglinBrute) {
                    PiglinBrute brute = (PiglinBrute)target;
                    visibleAdultPiglins.add(brute);
                    continue;
                }
                if (target instanceof Piglin) {
                    Piglin piglin = (Piglin)target;
                    if (!piglin.m_34667_()) continue;
                    visibleAdultPiglins.add(piglin);
                    continue;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (nearestPlayerWithoutGold == null && !PiglinAi.m_34808_((LivingEntity)player) && entity.m_6779_((LivingEntity)player)) {
                        nearestPlayerWithoutGold = player;
                    }
                    if (nearestPlayerWithWantedItem != null || player.m_5833_() || !PiglinAi.m_34883_((LivingEntity)player)) continue;
                    nearestPlayerWithWantedItem = player;
                    continue;
                }
                if (nemesis != null || !(target instanceof WitherSkeleton) && !(target instanceof WitherBoss)) {
                    if (nearestZombified != null || !PiglinAi.m_34806_((EntityType)target.m_6095_())) continue;
                    nearestZombified = target;
                    continue;
                }
                nemesis = (Mob)target;
            }
            BrainUtils.setMemory(brain, MemoryModuleType.f_26333_, nemesis);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26343_, nearestHuntableHoglin);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26344_, nearestBabyHoglin);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26351_, nearestZombified);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26345_, nearestPlayerWithoutGold);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26354_, nearestPlayerWithWantedItem);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26347_, visibleAdultPiglins);
            BrainUtils.setMemory(brain, MemoryModuleType.f_26352_, Integer.valueOf(visibleAdultPiglins.size()));
            BrainUtils.setMemory(brain, MemoryModuleType.f_26353_, Integer.valueOf(adultHoglinCount));
            BrainUtils.setMemory(brain, MemoryModuleType.f_26356_, (BlockPos)BlockPos.m_121930_((BlockPos)entity.m_20183_(), (int)8, (int)4, pos -> {
                BlockState state = level.m_8055_(pos);
                boolean isRepellent = state.m_204336_(BlockTags.f_13042_);
                return isRepellent && state.m_60713_(Blocks.f_50684_) ? CampfireBlock.m_51319_((BlockState)state) : isRepellent;
            }).orElse(null));
        });
        BrainUtils.withMemory(brain, MemoryModuleType.f_148204_, arg_0 -> PiglinSpecificSensor.lambda$doTick$3((List)adultPiglins, arg_0));
        BrainUtils.setMemory(brain, MemoryModuleType.f_26346_, adultPiglins);
    }

    private static /* synthetic */ void lambda$doTick$3(List adultPiglins, List entities) {
        for (LivingEntity target : entities) {
            AbstractPiglin piglin;
            if (!(target instanceof AbstractPiglin) || !(piglin = (AbstractPiglin)target).m_34667_()) continue;
            adultPiglins.add(piglin);
        }
    }
}

