/*
 * Decompiled with CFR 0.152.
 */
package elocindev.create_questing.forge.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import elocindev.create_questing.forge.config.ConfigEntries;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLPaths;

public class ConfigBuilder {
    public static final Gson BUILDER = new GsonBuilder().setPrettyPrinting().create();
    public static final Path file = FMLPaths.GAMEDIR.get().toAbsolutePath().resolve("config").resolve("create_questing.json");

    public static ConfigEntries loadConfig() {
        try {
            if (Files.notExists(file, new LinkOption[0])) {
                ConfigEntries exampleConfig = new ConfigEntries();
                exampleConfig.enable_theme_only_in_create_chapters = true;
                exampleConfig.create_chapter_names.add("create");
                exampleConfig.create_chapter_names.add("blueprint");
                exampleConfig.blueprint_background_scale = 0.5f;
                exampleConfig.blueprint_background_opacity = 0.9f;
                exampleConfig.blueprint_background_overlay_red = 255;
                exampleConfig.blueprint_background_overlay_green = 255;
                exampleConfig.blueprint_background_overlay_blue = 255;
                exampleConfig.debug_colorModifier = 0xFFFFFF;
                String defaultJson = BUILDER.toJson((Object)exampleConfig);
                Files.writeString(file, (CharSequence)defaultJson, new OpenOption[0]);
            }
            return (ConfigEntries)BUILDER.fromJson(Files.readString(file), ConfigEntries.class);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }
}

