/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.data.TeamRank;
import dev.ftb.mods.ftbteams.data.TeamType;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;

public class ClientTeam
extends TeamBase {
    private static List<TeamProperty> SYNCABLE_PROPS = List.of(DISPLAY_NAME, COLOR);
    public final ClientTeamManager manager;
    public boolean invalid;
    TeamType type;
    private final UUID ownerID;

    public static ClientTeam invalidTeam(ClientTeamManager m, Team team) {
        return new ClientTeam(m, team.getId());
    }

    private ClientTeam(ClientTeamManager m, UUID id) {
        this.id = id;
        this.manager = m;
        this.ownerID = Util.f_137441_;
        this.invalid = true;
        this.type = TeamType.PARTY;
    }

    public ClientTeam(ClientTeamManager m, FriendlyByteBuf buffer) {
        this.manager = m;
        this.id = buffer.m_130259_();
        this.type = (TeamType)buffer.m_130066_(TeamType.class);
        this.properties.read(buffer);
        int rs = buffer.m_130242_();
        for (int i = 0; i < rs; ++i) {
            this.ranks.put(buffer.m_130259_(), (TeamRank)buffer.m_130066_(TeamRank.class));
        }
        this.extraData = buffer.m_130260_();
        this.ownerID = buffer.readBoolean() ? buffer.m_130259_() : Util.f_137441_;
        this.invalid = buffer.readBoolean();
    }

    public ClientTeam(ClientTeamManager m, Team team) {
        this.manager = m;
        this.id = team.getId();
        this.type = team.getType();
        this.properties.updateFrom(team.properties);
        this.ranks.putAll(team.ranks);
        this.extraData = team.extraData == null ? null : team.extraData.m_6426_();
        this.ownerID = team.getOwner();
    }

    @Override
    public TeamType getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        return this.manager.teamMap.containsKey(this.id);
    }

    public void write(FriendlyByteBuf buffer, boolean writeAllProperties) {
        buffer.m_130077_(this.id);
        buffer.m_130068_((Enum)this.type);
        if (writeAllProperties) {
            this.properties.write(buffer);
        } else {
            this.properties.writeSyncableOnly(buffer, SYNCABLE_PROPS);
        }
        buffer.m_130130_(this.ranks.size());
        for (Map.Entry entry : this.ranks.entrySet()) {
            buffer.m_130077_((UUID)entry.getKey());
            buffer.m_130068_((Enum)entry.getValue());
        }
        buffer.m_130079_(this.extraData);
        boolean hasOwner = !this.ownerID.equals(Util.f_137441_);
        buffer.writeBoolean(hasOwner);
        if (hasOwner) {
            buffer.m_130077_(this.ownerID);
        }
        buffer.writeBoolean(this.invalid);
    }

    public boolean isSelf() {
        return this == this.manager.selfTeam;
    }

    public UUID getOwnerID() {
        return this.ownerID;
    }

    public void setMessageHistory(List<TeamMessage> messages) {
        this.messageHistory.clear();
        this.messageHistory.addAll(messages);
    }
}

