/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.undo;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class DestroySnapshot
implements ISnapshot {
    private final BlockState block;
    private final BlockPos pos;

    public DestroySnapshot(BlockState block, BlockPos pos) {
        this.pos = pos;
        this.block = block;
    }

    @Nullable
    public static DestroySnapshot get(Level world, Player player, BlockPos pos) {
        if (!WandUtil.isBlockRemovable(world, player, pos)) {
            return null;
        }
        return new DestroySnapshot(world.m_8055_(pos), pos);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getBlockState() {
        return this.block;
    }

    @Override
    public ItemStack getRequiredItems() {
        return ItemStack.f_41583_;
    }

    @Override
    public boolean execute(Level world, Player player, BlockHitResult rayTraceResult) {
        return WandUtil.removeBlock(world, player, this.block, this.pos);
    }

    @Override
    public boolean canRestore(Level world, Player player) {
        if (!world.m_46739_(this.pos)) {
            return false;
        }
        if (!world.m_7966_(player, this.pos)) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        if (!world.m_46859_(this.pos) && !world.m_8055_(this.pos).m_60722_(Fluids.f_76191_)) {
            return false;
        }
        return !WandUtil.entitiesCollidingWithBlock(world, this.block, this.pos);
    }

    @Override
    public boolean restore(Level world, Player player) {
        return WandUtil.placeBlock(world, player, this.block, this.pos, null);
    }

    @Override
    public void forceRestore(Level world) {
        world.m_46597_(this.pos, this.block);
    }
}

