/*
 * Decompiled with CFR 0.152.
 */
package de.canitzp.feederhelmet;

import de.canitzp.feederhelmet.FeederConfig;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemStackUtil {
    public static String getItemStackResourceLocationString(ItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).toString();
    }

    public static boolean isFoodBlacklisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.FOOD_BLACKLIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }

    public static boolean isFoodWhitelisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.FOOD_WHITELIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }

    public static boolean isSmeltable(Level level, ItemStack stack) {
        return level.m_7465_().m_44013_(RecipeType.f_44108_).stream().anyMatch(furnaceRecipe -> furnaceRecipe.m_7527_().stream().anyMatch(ingredient -> ingredient.test(stack)));
    }

    public static boolean isEatable(ItemStack stack) {
        return stack.m_41720_().m_41472_();
    }

    public static boolean isHelmetBlacklisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.HELMET_BLACKLIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }

    public static boolean isHelmetWhitelisted(ItemStack stack) {
        return ((List)FeederConfig.GENERAL.HELMET_WHITELIST.get()).contains(ItemStackUtil.getItemStackResourceLocationString(stack));
    }
}

