/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.ai.improvements.modifier;

import com.builtbroken.ai.improvements.modifier.editor.ModifierLayer;
import com.builtbroken.ai.improvements.modifier.filters.FilterLayer;
import com.builtbroken.ai.improvements.modifier.filters.FilterNode;
import com.builtbroken.ai.improvements.modifier.filters.FilterResult;
import com.builtbroken.ai.improvements.modifier.filters.IFilterNode;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;

public class ModifierLevel
extends FilterNode {
    public final ModifierLayer goalEditor = new ModifierLayer(false);
    public final ModifierLayer combatGoalEditor = new ModifierLayer(true);
    public final FilterLayer filters = new FilterLayer(null);

    public static ModifierLevel newFilter(Function<Entity, Boolean> filter) {
        return new ModifierLevel(entity -> (Boolean)filter.apply(entity) != false ? FilterResult.FILTERED : FilterResult.DID_NOTHING);
    }

    private ModifierLevel(IFilterNode filter) {
        super(filter);
    }

    @Override
    public FilterResult handle(Entity entity) {
        FilterResult filterResult = this.action.handle(entity);
        if (filterResult != FilterResult.DID_NOTHING) {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                this.goalEditor.handle(mob);
                this.combatGoalEditor.handle(mob);
            }
            return this.filters.handle(entity);
        }
        return filterResult;
    }
}

