/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.api.fluid;

import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.PlatformFluidHandler;
import earth.terrarium.botarium.api.fluid.PlatformFluidItemHandler;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHandler;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHolder;
import earth.terrarium.botarium.forge.fluid.ForgeFluidItemHandler;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class FluidHooks {
    public static FluidHolder newFluidHolder(Fluid fluid, long amount, CompoundTag tag) {
        return new ForgeFluidHolder(fluid, (int)amount, tag);
    }

    public static FluidHolder fluidFromCompound(CompoundTag compoundTag) {
        return ForgeFluidHolder.fromCompound(compoundTag);
    }

    public static FluidHolder emptyFluid() {
        return ForgeFluidHolder.empty();
    }

    public static long buckets(double buckets) {
        return (long)(buckets * (double)FluidHooks.getBucketAmount());
    }

    @Deprecated
    public static long buckets(int buckets) {
        return FluidHooks.buckets((double)buckets);
    }

    public static PlatformFluidItemHandler getItemFluidManager(ItemStack stack) {
        return new ForgeFluidItemHandler((IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElseThrow(IllegalArgumentException::new));
    }

    public static PlatformFluidHandler getBlockFluidManager(BlockEntity entity, @Nullable Direction direction) {
        return new ForgeFluidHandler((IFluidHandler)entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).orElseThrow(IllegalArgumentException::new));
    }

    public static boolean isFluidContainingBlock(BlockEntity entity, @Nullable Direction direction) {
        return entity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction).isPresent();
    }

    public static boolean isFluidContainingItem(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent();
    }

    public static Optional<PlatformFluidHandler> safeGetBlockFluidManager(BlockEntity entity, @Nullable Direction direction) {
        if (entity == null) {
            return Optional.empty();
        }
        return FluidHooks.isFluidContainingBlock(entity, direction) ? Optional.of(FluidHooks.getBlockFluidManager(entity, direction)) : Optional.empty();
    }

    public static Optional<PlatformFluidItemHandler> safeGetItemFluidManager(ItemStack stack) {
        return FluidHooks.isFluidContainingItem(stack) ? Optional.of(FluidHooks.getItemFluidManager(stack)) : Optional.empty();
    }

    public static long moveFluid(PlatformFluidHandler from, PlatformFluidHandler to, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(fluid, true);
        long inserted = to.insertFluid(extracted, true);
        from.extractFluid(FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(extracted, false);
    }

    public static long moveItemToStandardFluid(PlatformFluidItemHandler from, ItemStackHolder sender, PlatformFluidHandler to, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(sender.copy(), fluid, true);
        long inserted = to.insertFluid(extracted, true);
        from.extractFluid(sender, FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(extracted, false);
    }

    public static long moveStandardToItemFluid(PlatformFluidHandler from, PlatformFluidItemHandler to, ItemStackHolder receiver, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(fluid, true);
        long inserted = to.insertFluid(receiver, extracted, true);
        from.extractFluid(FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(receiver, extracted, false);
    }

    public static long moveItemToItemFluid(PlatformFluidItemHandler from, ItemStackHolder sender, PlatformFluidItemHandler to, ItemStackHolder receiver, FluidHolder fluid) {
        FluidHolder extracted = from.extractFluid(sender.copy(), fluid, true);
        long inserted = to.insertFluid(receiver, extracted, true);
        from.extractFluid(sender, FluidHooks.newFluidHolder(fluid.getFluid(), inserted, fluid.getCompound()), false);
        return to.insertFluid(receiver, extracted, false);
    }

    public static long safeMoveFluid(Optional<PlatformFluidHandler> from, Optional<PlatformFluidHandler> to, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveFluid(f, t, fluid))).orElse(0L);
    }

    public static long safeMoveItemToStandard(Optional<PlatformFluidItemHandler> from, ItemStackHolder sender, Optional<PlatformFluidHandler> to, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveItemToStandardFluid(f, sender, t, fluid))).orElse(0L);
    }

    public static long safeMoveStandardToItem(Optional<PlatformFluidHandler> from, Optional<PlatformFluidItemHandler> to, ItemStackHolder receiver, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveStandardToItemFluid(f, t, receiver, fluid))).orElse(0L);
    }

    public static long safeMoveItemToItem(Optional<PlatformFluidItemHandler> from, ItemStackHolder sender, Optional<PlatformFluidItemHandler> to, ItemStackHolder receiver, FluidHolder fluid) {
        return from.flatMap(f -> to.map(t -> FluidHooks.moveItemToItemFluid(f, sender, t, receiver, fluid))).orElse(0L);
    }

    public static long moveBlockToBlockFluid(BlockEntity from, @Nullable Direction fromDirection, BlockEntity to, @Nullable Direction toDirection, FluidHolder fluid) {
        return FluidHooks.safeMoveFluid(FluidHooks.safeGetBlockFluidManager(from, fromDirection), FluidHooks.safeGetBlockFluidManager(to, toDirection), fluid);
    }

    public static long moveBlockToItemFluid(BlockEntity from, @Nullable Direction fromDirection, ItemStackHolder to, FluidHolder fluid) {
        return FluidHooks.safeMoveStandardToItem(FluidHooks.safeGetBlockFluidManager(from, fromDirection), FluidHooks.safeGetItemFluidManager(to.getStack()), to, fluid);
    }

    public static long moveItemToBlockFluid(ItemStackHolder from, BlockEntity to, @Nullable Direction toDirection, FluidHolder fluid) {
        return FluidHooks.safeMoveItemToStandard(FluidHooks.safeGetItemFluidManager(from.getStack()), from, FluidHooks.safeGetBlockFluidManager(to, toDirection), fluid);
    }

    public static long moveItemToItemFluid(ItemStackHolder from, ItemStackHolder to, FluidHolder fluid) {
        return FluidHooks.safeMoveItemToItem(FluidHooks.safeGetItemFluidManager(from.getStack()), from, FluidHooks.safeGetItemFluidManager(to.getStack()), to, fluid);
    }

    public static long toMillibuckets(long amount) {
        return amount;
    }

    public static long getBucketAmount() {
        return 1000L;
    }

    public static long getBottleAmount() {
        return 250L;
    }

    public static long getBlockAmount() {
        return 1000L;
    }

    public static long getIngotAmount() {
        return 90L;
    }

    public static long getNuggetAmount() {
        return 10L;
    }
}

