/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge;

import earth.terrarium.botarium.api.energy.EnergyItem;
import earth.terrarium.botarium.api.fluid.FluidHoldingItem;
import earth.terrarium.botarium.forge.energy.ForgeItemEnergyContainer;
import earth.terrarium.botarium.forge.fluid.ForgeItemFluidContainer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BotariumItemCapabilityProvider
implements ICapabilityProvider {
    private final LazyOptional<ForgeItemFluidContainer> fluidHandler;
    private final LazyOptional<ForgeItemEnergyContainer> energyStorage;

    public BotariumItemCapabilityProvider(ItemStack item) {
        Item item2 = item.m_41720_();
        if (item2 instanceof FluidHoldingItem) {
            FluidHoldingItem fluidHoldingItem = (FluidHoldingItem)item2;
            this.fluidHandler = LazyOptional.of(() -> new ForgeItemFluidContainer(fluidHoldingItem.getFluidContainer(item), item));
        } else {
            this.fluidHandler = LazyOptional.empty();
        }
        item2 = item.m_41720_();
        if (item2 instanceof EnergyItem) {
            EnergyItem energyItem = (EnergyItem)item2;
            this.energyStorage = LazyOptional.of(() -> new ForgeItemEnergyContainer(energyItem.getEnergyStorage(item), item));
        } else {
            this.energyStorage = LazyOptional.empty();
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        if (capability == ForgeCapabilities.ENERGY) {
            return this.energyStorage.cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER_ITEM) {
            return this.fluidHandler.cast();
        }
        return LazyOptional.empty();
    }
}

