/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.extensions;

import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.item.ItemStackHolder;
import earth.terrarium.botarium.impl.energy.PlatformBlockEnergyManager;
import earth.terrarium.botarium.impl.energy.PlatformItemEnergyManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.msrandom.extensions.annotations.ClassExtension;
import org.jetbrains.annotations.Nullable;

@ClassExtension(value=EnergyContainer.class)
public interface EnergyContainerImpl {
    public static EnergyContainer of(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        PlatformBlockEnergyManager platformBlockEnergyManager = PlatformBlockEnergyManager.of(level, pos, state, entity, direction);
        return platformBlockEnergyManager == null ? EnergyApi.getAPIEnergyContainer(level, pos, state, entity, direction) : platformBlockEnergyManager;
    }

    public static EnergyContainer of(ItemStackHolder holder) {
        return PlatformItemEnergyManager.of(holder);
    }

    public static boolean holdsEnergy(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    public static boolean holdsEnergy(Level level, BlockPos pos, BlockState state, @Nullable BlockEntity entity, @Nullable Direction direction) {
        return entity != null && entity.getCapability(ForgeCapabilities.ENERGY, direction).isPresent() || EnergyApi.getAPIEnergyContainer(level, pos, state, entity, direction) != null;
    }
}

