/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.impl.regsitry.fluid;

import earth.terrarium.botarium.common.registry.fluid.FluidInformation;
import earth.terrarium.botarium.common.registry.fluid.FluidProperties;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundAction;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BotariumFluidType
extends FluidType {
    private final FluidInformation information;

    private BotariumFluidType(FluidInformation information, FluidType.Properties properties) {
        super(properties);
        this.information = information;
    }

    public static BotariumFluidType create(FluidInformation information) {
        FluidType.Properties properties = FluidType.Properties.create();
        properties.descriptionId(Util.m_137492_((String)"fluid_type", (ResourceLocation)information.id()));
        properties.adjacentPathType(information.adjacentPathType());
        properties.canConvertToSource(information.canConvertToSource());
        properties.canDrown(information.canDrown());
        properties.canExtinguish(information.canExtinguish());
        properties.canHydrate(information.canHydrate());
        properties.canPushEntity(information.canPushEntity());
        properties.canSwim(information.canSwim());
        properties.density(information.density());
        properties.fallDistanceModifier(information.fallDistanceModifier());
        properties.lightLevel(information.lightLevel());
        properties.motionScale(information.motionScale());
        properties.pathType(information.pathType());
        properties.rarity(information.rarity());
        properties.temperature(information.temperature());
        properties.viscosity(information.viscosity());
        information.sounds().getSounds().forEach((name, sound) -> properties.sound(SoundAction.get((String)name), sound));
        return new BotariumFluidType(information, properties);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static BotariumFluidType of(FluidProperties fluidProperties) {
        FluidType.Properties properties = FluidType.Properties.create();
        properties.descriptionId(Util.m_137492_((String)"fluid_type", (ResourceLocation)fluidProperties.id()));
        properties.adjacentPathType(fluidProperties.adjacentPathType());
        properties.canConvertToSource(fluidProperties.canConvertToSource());
        properties.canDrown(fluidProperties.canDrown());
        properties.canExtinguish(fluidProperties.canExtinguish());
        properties.canHydrate(fluidProperties.canHydrate());
        properties.canPushEntity(fluidProperties.canPushEntity());
        properties.canSwim(fluidProperties.canSwim());
        properties.density(fluidProperties.density());
        properties.fallDistanceModifier(fluidProperties.fallDistanceModifier());
        properties.lightLevel(fluidProperties.lightLevel());
        properties.motionScale(fluidProperties.motionScale());
        properties.pathType(fluidProperties.pathType());
        properties.rarity(fluidProperties.rarity());
        properties.temperature(fluidProperties.temperature());
        properties.viscosity(fluidProperties.viscosity());
        fluidProperties.sounds().getSounds().forEach((name, sound) -> properties.sound(SoundAction.get((String)name), sound));
        return new BotariumFluidType(fluidProperties, properties);
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        final BotariumFluidType type = this;
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getStillTexture() {
                return type.information.still();
            }

            public ResourceLocation getFlowingTexture() {
                return type.information.flowing();
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return type.information.overlay();
            }

            @Nullable
            public ResourceLocation getRenderOverlayTexture(Minecraft mc) {
                return type.information.screenOverlay();
            }

            public int getTintColor() {
                return type.information.tintColor();
            }
        });
    }
}

