/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.menu.AutomationNasaWorkbenchMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import ad_astra_giselle_addon.common.world.ContainerUtils;
import earth.terrarium.ad_astra.common.recipe.IngredientHolder;
import earth.terrarium.ad_astra.common.recipe.NasaWorkbenchRecipe;
import earth.terrarium.ad_astra.common.util.ModUtils;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.api.energy.SimpleUpdatingEnergyContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutomationNasaWorkbenchBlockEntity
extends AddonMachineBlockEntity
implements EnergyBlock {
    public static final int RESULT_SLOT = 14;
    public static final String DATA_COOK_TIME_KEY = "cookTime";
    public static final String DATA_COOK_TIME_TOTAL_KEY = "cookTimeTotal";
    private SimpleUpdatingEnergyContainer energyStorage;
    private boolean firstTick = true;
    private List<RecipeCache> recipaCaches = new ArrayList<RecipeCache>();
    private NasaWorkbenchRecipe selectedRecipe = null;
    private int cookTime;
    private int cookTimeTotal;

    public AutomationNasaWorkbenchBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockEntityTypes.AUTOMATION_NASA_WORKBENCH.get(), pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cookTime = nbt.m_128451_(DATA_COOK_TIME_KEY);
        this.cookTimeTotal = nbt.m_128451_(DATA_COOK_TIME_TOTAL_KEY);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_(DATA_COOK_TIME_KEY, this.cookTime);
        nbt.m_128405_(DATA_COOK_TIME_TOTAL_KEY, this.cookTimeTotal);
    }

    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new AutomationNasaWorkbenchMenu(syncId, inv, this);
    }

    public void update() {
    }

    public int getInventorySize() {
        return 15;
    }

    @Override
    public int getSideSlotLimit(int slot, @Nullable Direction directon) {
        return 1;
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        if (slot == 14) {
            return false;
        }
        return this.recipaCaches.stream().filter(cache -> cache.testRemain(slot, stack)).findAny().isPresent();
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return slot == 14;
    }

    public SimpleUpdatingEnergyContainer getEnergyStorage() {
        if (this.energyStorage == null) {
            this.energyStorage = new SimpleUpdatingEnergyContainer((Updatable)this, MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_CAPACITY);
        }
        return this.energyStorage;
    }

    public void tick() {
        if (!this.m_58904_().m_5776_()) {
            if (this.firstTick) {
                this.firstTick = false;
                this.cacheRecipes();
            }
            if (this.recipaCaches.stream().anyMatch(RecipeCache::anyAdded)) {
                this.spawnWorkingParticles();
            }
            this.cook();
        }
    }

    public void spawnWorkingParticles() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            ModUtils.spawnForcedParticles((ServerLevel)level2, (ParticleOptions)ParticleTypes.f_123797_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.5), (double)((double)pos.m_123343_() + 0.5), (int)10, (double)0.1, (double)0.1, (double)0.1, (double)0.1);
        }
    }

    public void spawnResultParticles() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            ModUtils.spawnForcedParticles((ServerLevel)level2, (ParticleOptions)ParticleTypes.f_123767_, (double)((double)pos.m_123341_() + 0.5), (double)((double)pos.m_123342_() + 1.5), (double)((double)pos.m_123343_() + 0.5), (int)100, (double)0.1, (double)0.1, (double)0.1, (double)0.7);
            level2.m_5594_(null, pos, SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private void cook() {
        NasaWorkbenchRecipe recipe = this.selectedRecipe;
        if (recipe == null) {
            return;
        }
        NonNullList items = this.getItems();
        List ingredients = recipe.getHolders();
        ItemStack resultItem = recipe.m_8043_();
        if (this.testIngredientCounts(recipe.getHolders(), (List<ItemStack>)items) && ContainerUtils.insert((Container)this, 14, resultItem, true).m_41619_() && this.extractEnergy(true)) {
            this.setCookTime(this.getCookTime() + 1);
            this.extractEnergy(false);
            if (this.getCookTime() >= this.getCookTimeTotal()) {
                for (int i = 0; i < 14; ++i) {
                    ((ItemStack)items.get(i)).m_41774_(((IngredientHolder)ingredients.get(i)).count());
                }
                this.setCookTime(0);
                ContainerUtils.insert((Container)this, 14, resultItem, false);
                this.spawnResultParticles();
            }
        } else {
            this.setCookTime(0);
        }
    }

    public boolean extractEnergy(boolean simulate) {
        long extracting = MachinesConfig.AUTOMATION_NASA_WORKBENCH_ENERGY_USAGE;
        PlatformEnergyManager energyManager = EnergyHooks.getBlockEnergyManager((BlockEntity)this, null);
        return energyManager.extract(extracting, simulate) == extracting;
    }

    private void cacheRecipes() {
        NonNullList items = this.getItems();
        List recipes = NasaWorkbenchRecipe.getRecipes((Level)this.m_58904_());
        this.recipaCaches.clear();
        this.recipaCaches.addAll(recipes.stream().map(arg_0 -> this.lambda$cacheRecipes$1((List)items, arg_0)).filter(cache -> cache != null).toList());
        this.selectedRecipe = this.recipaCaches.stream().filter(arg_0 -> this.lambda$cacheRecipes$3((List)items, arg_0)).map(RecipeCache::recipe).findFirst().orElse(null);
        if (this.selectedRecipe == null) {
            this.setCookTimeTotal(0);
        } else {
            this.setCookTimeTotal(MachinesConfig.AUTOMATION_NASA_WORKBENCH_COOK_TIME);
        }
    }

    private boolean test(RecipeCache cache, List<ItemStack> items) {
        return cache.isComplete() && this.testIngredientCounts(cache.recipe().getHolders(), items);
    }

    private boolean testIngredientCounts(List<IngredientHolder> ingredients, List<ItemStack> items) {
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack item = items.get(i);
            IngredientHolder ingredient = ingredients.get(i);
            if (item.m_41613_() >= ingredient.count()) continue;
            return false;
        }
        return true;
    }

    private RecipeCache cache(NasaWorkbenchRecipe recipe, List<ItemStack> items) {
        List ingredients = recipe.getHolders();
        ArrayList<SlotWithIngredient> remainIngredients = new ArrayList<SlotWithIngredient>();
        boolean mismatched = false;
        boolean anyAdded = false;
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack item = items.get(i);
            Ingredient ingredient = ((IngredientHolder)ingredients.get(i)).ingredient();
            boolean needAdd = false;
            if (item.m_41619_()) {
                needAdd = true;
            } else if (!ingredient.test(item)) {
                needAdd = true;
                mismatched = true;
            } else {
                anyAdded = true;
            }
            if (!needAdd) continue;
            remainIngredients.add(new SlotWithIngredient(i, ingredient));
        }
        if (!mismatched) {
            return new RecipeCache(recipe, remainIngredients, anyAdded);
        }
        return null;
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.m_58904_() instanceof ServerLevel) {
            this.cacheRecipes();
        }
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        cookTime = Mth.m_14045_((int)cookTime, (int)0, (int)this.getCookTimeTotal());
        if (this.getCookTime() != cookTime) {
            this.cookTime = cookTime;
        }
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    protected void setCookTimeTotal(int cookTimeTotal) {
        cookTimeTotal = Math.max(cookTimeTotal, 0);
        if (this.getCookTimeTotal() != cookTimeTotal) {
            this.cookTimeTotal = cookTimeTotal;
            this.setCookTime(this.getCookTime());
        }
    }

    private /* synthetic */ boolean lambda$cacheRecipes$3(List items, RecipeCache cache) {
        return this.test(cache, items);
    }

    private /* synthetic */ RecipeCache lambda$cacheRecipes$1(List items, NasaWorkbenchRecipe recipe) {
        return this.cache(recipe, items);
    }

    private record RecipeCache(NasaWorkbenchRecipe recipe, List<SlotWithIngredient> remainIngredients, boolean anyAdded) {
        public boolean testRemain(int putSlot, ItemStack item) {
            List<SlotWithIngredient> remainIngredients = this.remainIngredients();
            return remainIngredients.stream().filter(i -> i.test(putSlot, item)).findAny().isPresent();
        }

        public boolean isComplete() {
            return this.remainIngredients().size() == 0;
        }
    }

    private record SlotWithIngredient(int slot, Ingredient ingredient) {
        public boolean test(int putSlot, ItemStack item) {
            return putSlot == this.slot() && this.ingredient().test(item);
        }
    }
}

