/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.block.entity.AddonMachineBlockEntity;
import ad_astra_giselle_addon.common.block.entity.IWorkingAreaBlockEntity;
import ad_astra_giselle_addon.common.config.MachinesConfig;
import ad_astra_giselle_addon.common.content.proof.GravityProofUtils;
import ad_astra_giselle_addon.common.menu.GravityNormalizerMenu;
import ad_astra_giselle_addon.common.registry.AddonBlockEntityTypes;
import ad_astra_giselle_addon.common.registry.AddonProofs;
import ad_astra_giselle_addon.common.util.Vec3iUtils;
import com.mojang.serialization.DynamicOps;
import earth.terrarium.botarium.api.Updatable;
import earth.terrarium.botarium.api.energy.EnergyBlock;
import earth.terrarium.botarium.api.energy.EnergyHooks;
import earth.terrarium.botarium.api.energy.PlatformEnergyManager;
import earth.terrarium.botarium.api.energy.SimpleUpdatingEnergyContainer;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class GravityNormalizerBlockEntity
extends AddonMachineBlockEntity
implements EnergyBlock,
IWorkingAreaBlockEntity {
    public static final String DATA_LENGTH_KEY = "length";
    public static final String DATA_OFFSET_KEY = "offset";
    public static final String DATA_TIMER_KEY = "timer";
    public static final String DATA_WORKINGAREA_VISIBLE_KEY = "workingAreaVisible";
    private SimpleUpdatingEnergyContainer energyStorage;
    private Vec3i length = new Vec3i(3, 3, 3);
    private Vec3i offset = GravityNormalizerBlockEntity.offsetFromLength(this.length);
    private int timer = 0;
    private boolean workingAreaVisible = false;

    public GravityNormalizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)AddonBlockEntityTypes.GRAVITY_NORMALIZER.get(), pos, state);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new GravityNormalizerMenu(windowId, inv, this);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.length = (Vec3i)Vec3i.f_123287_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_(DATA_LENGTH_KEY)).result().get();
        this.offset = (Vec3i)Vec3i.f_123287_.parse((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_(DATA_OFFSET_KEY)).result().get();
        this.timer = nbt.m_128451_(DATA_TIMER_KEY);
        this.workingAreaVisible = nbt.m_128471_(DATA_WORKINGAREA_VISIBLE_KEY);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_(DATA_LENGTH_KEY, (Tag)Vec3i.f_123287_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.length).result().get());
        nbt.m_128365_(DATA_OFFSET_KEY, (Tag)Vec3i.f_123287_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.offset).result().get());
        nbt.m_128405_(DATA_TIMER_KEY, this.timer);
        nbt.m_128379_(DATA_WORKINGAREA_VISIBLE_KEY, this.workingAreaVisible);
    }

    public SimpleUpdatingEnergyContainer getEnergyStorage() {
        if (this.energyStorage == null) {
            this.energyStorage = new SimpleUpdatingEnergyContainer((Updatable)this, MachinesConfig.GRAVITY_NORMALIZER_ENERGY_CAPACITY){

                public long maxExtract() {
                    return this.getMaxCapacity();
                }

                public long maxInsert() {
                    return this.getMaxCapacity();
                }
            };
        }
        return this.energyStorage;
    }

    public void update() {
    }

    public void tick() {
        int timer = this.getTimer();
        if (--timer <= 0) {
            timer = this.getMaxTimer();
            AABB workingArea = this.getWorkingArea();
            this.doNormalize(workingArea);
            this.m_6596_();
        }
        this.setTimer(timer);
    }

    protected void doNormalize(AABB workingArea) {
        Level level = this.m_58904_();
        GravityProofUtils proof = AddonProofs.GRAVITY;
        long energyUsing = this.getEnergyUsing(workingArea);
        PlatformEnergyManager energyManager = EnergyHooks.getBlockEnergyManager((BlockEntity)this, null);
        if (energyManager.extract(energyUsing, true) < energyUsing) {
            return;
        }
        List entities = level.m_45933_(null, workingArea);
        if (entities.size() <= 0) {
            return;
        }
        energyManager.extract(energyUsing, false);
        int proofDuration = this.getMaxTimer() + 1;
        for (Entity entity : entities) {
            if (proof.getProofDuration(entity) > proofDuration) continue;
            proof.setProofDuration(entity, proofDuration);
        }
    }

    public long getEnergyUsing() {
        return this.getEnergyUsing(this.getWorkingArea());
    }

    public long getEnergyUsing(AABB workingArea) {
        double blocks = workingArea.m_82362_() * workingArea.m_82376_() * workingArea.m_82385_();
        return (long)(MachinesConfig.GRAVITY_NORMALIZER_ENERGY_PER_BLOCKS * blocks);
    }

    public static int getMinLength() {
        return 1;
    }

    public static int getMaxLength() {
        return MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH;
    }

    public Vec3i getLength() {
        return this.length;
    }

    public void setLength(Vec3i length) {
        length = Vec3iUtils.clamp(length, GravityNormalizerBlockEntity.getMinLength(), GravityNormalizerBlockEntity.getMaxLength());
        if (!this.getLength().equals((Object)length)) {
            this.length = length;
            this.m_6596_();
        }
    }

    public static int half(int length) {
        return (length - 1) / 2;
    }

    public static int offsetFromLength(int length) {
        return -GravityNormalizerBlockEntity.half(length);
    }

    public static Vec3i offsetFromLength(Vec3i length) {
        int x = GravityNormalizerBlockEntity.offsetFromLength(length.m_123341_());
        int y = 0;
        int z = GravityNormalizerBlockEntity.offsetFromLength(length.m_123343_());
        return new Vec3i(x, y, z);
    }

    public static int getMinOffset() {
        return -GravityNormalizerBlockEntity.half(MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH);
    }

    public static int getMaxOffset() {
        return GravityNormalizerBlockEntity.half(MachinesConfig.GRAVITY_NORMALIZER_MAX_LENGTH);
    }

    public Vec3i getOffset() {
        return this.offset;
    }

    public void setOffset(Vec3i offset) {
        offset = Vec3iUtils.clamp(offset, GravityNormalizerBlockEntity.getMinOffset(), GravityNormalizerBlockEntity.getMaxOffset());
        if (!this.getOffset().equals((Object)offset)) {
            this.offset = offset;
            this.m_6596_();
        }
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        timer = Math.max(timer, 0);
        if (this.getTimer() != timer) {
            this.timer = timer;
        }
    }

    public int getMaxTimer() {
        return MachinesConfig.GRAVITY_NORMALIZER_PROOF_DURATION;
    }

    @Override
    public AABB getWorkingArea() {
        return this.getWorkingArea(this.m_58899_());
    }

    @Override
    public AABB getWorkingArea(BlockPos pos) {
        Vec3i length = this.getLength();
        Vec3i offset = this.getOffset();
        double x = ((double)length.m_123341_() - 1.0) / 2.0;
        double y = ((double)length.m_123342_() - 1.0) / 2.0;
        double z = ((double)length.m_123343_() - 1.0) / 2.0;
        return new AABB(pos).m_82377_(x, y, z).m_82386_(x + (double)offset.m_123341_(), y + (double)offset.m_123342_(), z + (double)offset.m_123343_());
    }

    @Override
    public boolean isWorkingAreaVisible() {
        return this.workingAreaVisible;
    }

    @Override
    public void setWorkingAreaVisible(boolean visible) {
        if (this.isWorkingAreaVisible() != visible) {
            this.workingAreaVisible = visible;
            this.m_6596_();
        }
    }
}

