/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.block.entity;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.block.entity.IRocketSensingType;
import ad_astra_giselle_addon.common.registry.AddonItems;
import ad_astra_giselle_addon.common.util.RedstoneUtils;
import earth.terrarium.ad_astra.common.config.VehiclesConfig;
import earth.terrarium.ad_astra.common.entity.vehicle.Lander;
import earth.terrarium.ad_astra.common.entity.vehicle.Rocket;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import earth.terrarium.ad_astra.common.registry.ModItems;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RocketSensingType implements IRocketSensingType
{
    DISABLED(AdAstraGiselleAddon.rl("disabled")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            return 0;
        }

        @Override
        public ItemStack getDisplayIcon() {
            return new ItemStack((ItemLike)Items.f_42403_);
        }
    }
    ,
    FOUND(AdAstraGiselleAddon.rl("found")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            return 15;
        }

        @Override
        public ItemStack getDisplayIcon() {
            return new ItemStack((ItemLike)Items.f_42451_);
        }
    }
    ,
    FLYING_UP(AdAstraGiselleAddon.rl("flying_up")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            Rocket rocket = (Rocket)vehicle;
            return RedstoneUtils.onOff(rocket.isFlying() && rocket.getCountdownTicks() <= 0);
        }

        @Override
        public ItemStack getDisplayIcon() {
            return new ItemStack((ItemLike)ModItems.TIER_1_ROCKET.get());
        }
    }
    ,
    FUEL_LOADED(AdAstraGiselleAddon.rl("fuel_loaded")){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            Rocket rocket = (Rocket)vehicle;
            return RedstoneUtils.onOff(rocket.getTankAmount() >= Rocket.getRequiredAmountForLaunch((Fluid)rocket.getTankFluid()));
        }

        @Override
        public ItemStack getDisplayIcon() {
            return new ItemStack((ItemLike)ModItems.FUEL_BUCKET.get());
        }
    }
    ,
    LAUNCH_COUNTDOWN(AdAstraGiselleAddon.rl("launch_countdown"), 2){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Rocket;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            Rocket rocket = (Rocket)vehicle;
            int max = VehiclesConfig.RocketConfig.countDownTicks;
            return rocket.isFlying() ? RedstoneUtils.range((double)(max - rocket.getCountdownTicks()) / (double)max) : 0;
        }

        @Override
        public ItemStack getDisplayIcon() {
            return new ItemStack((ItemLike)ModItems.LAUNCH_PAD.get());
        }
    }
    ,
    LANDER_FOUND(AdAstraGiselleAddon.rl("lander_found"), 1){

        @Override
        public boolean test(Vehicle vehicle) {
            return vehicle instanceof Lander;
        }

        @Override
        public int getAnalogSignal(Vehicle vehicle) {
            return 15;
        }

        @Override
        public ItemStack getDisplayIcon() {
            return new ItemStack((ItemLike)AddonItems.LANDER_ICON.get());
        }
    };

    private final ResourceLocation name;
    private final Component displayName;
    private final List<Component> tooltip;

    private RocketSensingType(ResourceLocation name) {
        this(name, 1);
    }

    private RocketSensingType(ResourceLocation name, int tooltipLines) {
        this.name = name;
        this.displayName = Component.m_237115_((String)AdAstraGiselleAddon.tl("rocket_sensing_type", name));
        Object[] tooltipParams = new Object[]{0, 15};
        this.tooltip = tooltipLines == 1 ? Collections.singletonList(Component.m_237110_((String)AdAstraGiselleAddon.tl("rocket_sensing_type", name, "desc"), (Object[])tooltipParams)) : IntStream.range(0, tooltipLines).mapToObj(i -> Component.m_237110_((String)AdAstraGiselleAddon.tl("rocket_sensing_type", name, "desc" + (i + 1)), (Object[])tooltipParams)).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public ResourceLocation getName() {
        return this.name;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public List<Component> getTooltip() {
        return this.tooltip;
    }

    @Override
    public abstract boolean test(Vehicle var1);

    @Override
    public abstract int getAnalogSignal(Vehicle var1);
}

