/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.content.oxygen.IOxygenStorage;
import ad_astra_giselle_addon.common.content.oxygen.OxygenStorageUtils;
import ad_astra_giselle_addon.common.content.proof.ProofAbstractUtils;
import ad_astra_giselle_addon.common.content.proof.ProofEnchantmentFunction;
import ad_astra_giselle_addon.common.entity.LivingHelper;
import ad_astra_giselle_addon.common.item.ItemStackReference;
import ad_astra_giselle_addon.common.item.ItemUsableResource;
import ad_astra_giselle_addon.common.registry.AddonEnchantments;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;

public class OxygenProofEnchantmentFunction
extends ProofEnchantmentFunction {
    @Override
    public Enchantment getEnchantment() {
        return AddonEnchantments.OXYGEN_PROOF.get();
    }

    @Override
    public boolean consume(LivingEntity living, EquipmentSlot slot, ItemStackReference enchantedItem, ItemUsableResource resource, boolean simulate) {
        if (!LivingHelper.isPlayingMode(living)) {
            return true;
        }
        long oxygenUsing = this.getOxygenUsing(resource);
        IOxygenStorage oxygenStorage = OxygenStorageUtils.firstExtractable(living, oxygenUsing);
        if (oxygenStorage == null) {
            return false;
        }
        long extracted = oxygenStorage.extractOxygen(living, oxygenUsing, simulate);
        return extracted >= oxygenUsing;
    }

    @Override
    public long getResourceUsingAmount(ItemUsableResource resource) {
        return 0L;
    }

    @Override
    public int getProofDuration(ItemUsableResource resource) {
        return 30;
    }

    public long getOxygenUsing(ItemUsableResource resource) {
        return ProofAbstractUtils.OXYGEN_PROOF_USING;
    }
}

