/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.registry;

import ad_astra_giselle_addon.common.registry.ObjectRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class ObjectRegistryDelegate
implements ObjectRegistry.Delegate {
    private final Map<ResourceKey<?>, InternalRegistry<?>> internals = new HashMap();

    @Override
    public <T> ObjectRegistry<T> get(ResourceKey<? extends Registry<T>> key) {
        return this.internals.computeIfAbsent(key, k -> new InternalRegistry(k));
    }

    private class InternalRegistry<T>
    extends ObjectRegistry<T> {
        private final ResourceKey<? extends Registry<T>> key;
        private final Map<String, DeferredRegister<T>> registries;

        private InternalRegistry(ResourceKey<? extends Registry<T>> key) {
            this.key = key;
            this.registries = new HashMap<String, DeferredRegister<T>>();
        }

        @Override
        public Supplier<T> register(ResourceLocation id, Supplier<? extends T> initializer) {
            DeferredRegister register = this.registries.computeIfAbsent(id.m_135827_(), this::createDeferredRegister);
            return register.register(id.m_135815_(), initializer);
        }

        private DeferredRegister<T> createDeferredRegister(String modid) {
            DeferredRegister register = DeferredRegister.create(this.key, (String)modid);
            register.register(FMLJavaModLoadingContext.get().getModEventBus());
            return register;
        }

        private ForgeRegistry<T> getRegistry() {
            return RegistryManager.ACTIVE.getRegistry(this.key);
        }

        @Override
        public ResourceLocation getId(T value) {
            return this.getRegistry().getKey(value);
        }

        @Override
        public T getValue(ResourceLocation id) {
            return (T)this.getRegistry().getValue(id);
        }

        @Override
        public Iterable<T> getValues() {
            return this.getRegistry();
        }
    }
}

