/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.DataStructures;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.LocationData;
import com.darkere.crashutils.DataStructures.WorldPos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class TileEntityData
extends LocationData {
    Map<ResourceLocation, Boolean> tickmap = new HashMap<ResourceLocation, Boolean>();
    public static Map<UUID, WorldPos> TEID = new HashMap<UUID, WorldPos>();

    public TileEntityData() {
        for (Map.Entry entry : ForgeRegistries.BLOCK_ENTITY_TYPES.getEntries()) {
            this.map.put(((ResourceKey)entry.getKey()).m_135782_(), new ArrayList());
        }
    }

    public TileEntityData(Map<ResourceLocation, List<WorldPos>> map) {
        this.map = map;
    }

    public void createLists(List<ServerLevel> worlds) {
        ArrayList ticking = new ArrayList();
        worlds.forEach(level -> {
            for (ChunkHolder chunk : level.m_7726_().f_8325_.m_140416_()) {
                if (chunk.m_140085_() == null) continue;
                ticking.addAll(chunk.m_140085_().m_62954_().values());
            }
            for (TickingBlockEntity tileEntity : level.f_151512_) {
                WorldPos pos = WorldPos.getPosFromTileEntity(tileEntity, (Level)level);
                TEID.put(pos.getID(), pos);
                ((List)this.map.get(new ResourceLocation(tileEntity.m_142280_()))).add(pos);
            }
        });
        this.total = ticking.size();
    }

    public void reply(ResourceLocation res, CommandSourceStack source) {
        if (res == null) {
            this.map.entrySet().stream().filter(x -> ((List)x.getValue()).size() != 0).sorted(Comparator.comparingInt(e -> ((List)e.getValue()).size())).forEach(e -> CommandUtils.sendFindTEMessage(source, (ResourceLocation)e.getKey(), ((List)e.getValue()).size(), this.tickmap.containsKey(e.getKey())));
            CommandUtils.sendNormalMessage(source, this.total + " BE's", ChatFormatting.DARK_AQUA);
        } else {
            ((List)this.map.get(res)).forEach(x -> CommandUtils.sendTEMessage(source, x, true));
        }
    }
}

