/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.packet.ButtonClickPacket;

public abstract class ContainerScreenExtended<T extends ContainerExtended>
extends AbstractContainerScreen<T>
implements IValueNotifiable {
    protected T container;
    protected ResourceLocation texture;
    protected int offsetX = 0;
    protected int offsetY = 0;

    public ContainerScreenExtended(T container, Inventory playerInventory, Component title) {
        super(container, playerInventory, title);
        ((ContainerExtended)container).setGuiValueListener(this);
        this.container = container;
        this.texture = this.constructGuiTexture();
    }

    protected abstract ResourceLocation constructGuiTexture();

    public ResourceLocation getGuiTexture() {
        return this.texture;
    }

    public void m_7856_() {
        this.f_97726_ = this.getBaseXSize() + this.offsetX * 2;
        this.f_97727_ = this.getBaseYSize() + this.offsetY * 2;
        super.m_7856_();
    }

    public final void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.drawCurrentScreen(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void drawCurrentScreen(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected int getBaseXSize() {
        return 176;
    }

    protected int getBaseYSize() {
        return 166;
    }

    protected void m_7286_(PoseStack matrixStack, float f, int x, int y) {
        RenderHelpers.bindTexture(this.getGuiTexture());
        this.m_93228_(matrixStack, this.f_97735_ + this.offsetX, this.f_97736_ + this.offsetY, 0, 0, this.f_97726_ - 2 * this.offsetX, this.f_97727_ - 2 * this.offsetY);
    }

    public boolean m_97774_(Slot slotIn, double mouseX, double mouseY) {
        return this.m_6774_(slotIn.f_40220_ - 1, slotIn.f_40221_ - 1, GuiHelpers.SLOT_SIZE, GuiHelpers.SLOT_SIZE, mouseX, mouseY);
    }

    public boolean m_6774_(int left, int top, int right, int bottom, double pointX, double pointY) {
        return RenderHelpers.isPointInRegion(left, top, right, bottom, pointX - (double)this.f_97735_, pointY - (double)this.f_97736_);
    }

    public boolean isPointInRegion(Rectangle region, Point mouse) {
        return this.m_6774_(region.x, region.y, region.width, region.height, mouse.x, mouse.y);
    }

    public void drawTooltip(List<Component> lines, PoseStack poseStack, int x, int y) {
        GuiHelpers.drawTooltip(this, poseStack, lines, x, y);
    }

    protected Button.OnPress createServerPressable(String buttonId, @Nullable Button.OnPress clientPressable) {
        return button -> {
            if (clientPressable != null) {
                clientPressable.m_93750_(button);
            }
            if (((ContainerExtended)this.m_6262_()).onButtonClick(buttonId)) {
                CyclopsCore._instance.getPacketHandler().sendToServer(new ButtonClickPacket(buttonId));
            }
        };
    }

    @Override
    public void onUpdate(int valueId, CompoundTag value) {
    }

    protected void refreshValues() {
        for (int id : ((ContainerExtended)this.m_6262_()).getValueIds()) {
            this.onUpdate(id, ((ContainerExtended)this.m_6262_()).getValue(id));
        }
    }

    public int getGuiLeftTotal() {
        return this.f_97735_ + this.offsetX;
    }

    public int getGuiTopTotal() {
        return this.f_97736_ + this.offsetY;
    }

    @Override
    public MenuType<?> getValueNotifiableType() {
        return ((ContainerExtended)this.m_6262_()).m_6772_();
    }
}

